/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.restassured;

import io.qameta.allure.attachment.AttachmentData;
import io.qameta.allure.attachment.AttachmentRenderer;
import io.qameta.allure.attachment.DefaultAttachmentProcessor;
import io.qameta.allure.attachment.FreemarkerAttachmentRenderer;
import io.qameta.allure.attachment.http.HttpRequestAttachment;
import io.qameta.allure.attachment.http.HttpResponseAttachment;
import io.restassured.filter.FilterContext;
import io.restassured.filter.OrderedFilter;
import io.restassured.internal.NameAndValue;
import io.restassured.internal.support.Prettifier;
import io.restassured.response.Response;
import io.restassured.response.ResponseOptions;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.FilterableResponseSpecification;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;

public class AllureRestAssured
implements OrderedFilter {
    private static final String HIDDEN_PLACEHOLDER = "[ BLACKLISTED ]";
    private String requestTemplatePath = "http-request.ftl";
    private String responseTemplatePath = "http-response.ftl";
    private String requestAttachmentName = "Request";
    private String responseAttachmentName;

    public AllureRestAssured setRequestTemplate(String templatePath) {
        this.requestTemplatePath = templatePath;
        return this;
    }

    public AllureRestAssured setResponseTemplate(String templatePath) {
        this.responseTemplatePath = templatePath;
        return this;
    }

    public AllureRestAssured setRequestAttachmentName(String requestAttachmentName) {
        this.requestAttachmentName = requestAttachmentName;
        return this;
    }

    public AllureRestAssured setResponseAttachmentName(String responseAttachmentName) {
        this.responseAttachmentName = responseAttachmentName;
        return this;
    }

    @Deprecated
    public AllureRestAssured withRequestTemplate(String templatePath) {
        return this.setRequestTemplate(templatePath);
    }

    @Deprecated
    public AllureRestAssured withResponseTemplate(String templatePath) {
        return this.setResponseTemplate(templatePath);
    }

    public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext filterContext) {
        Prettifier prettifier = new Prettifier();
        String url = requestSpec.getURI();
        TreeSet<String> hiddenHeaders = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        hiddenHeaders.addAll(Objects.requireNonNull(requestSpec.getConfig().getLogConfig().blacklistedHeaders()));
        HttpRequestAttachment.Builder requestAttachmentBuilder = HttpRequestAttachment.Builder.create((String)this.requestAttachmentName, (String)url).setMethod(requestSpec.getMethod()).setHeaders(AllureRestAssured.toMapConverter((Iterable<? extends NameAndValue>)requestSpec.getHeaders(), hiddenHeaders)).setCookies(AllureRestAssured.toMapConverter((Iterable<? extends NameAndValue>)requestSpec.getCookies(), new HashSet<String>()));
        if (Objects.nonNull(requestSpec.getBody())) {
            requestAttachmentBuilder.setBody(prettifier.getPrettifiedBodyIfPossible(requestSpec));
        }
        if (Objects.nonNull(requestSpec.getFormParams())) {
            requestAttachmentBuilder.setFormParams(requestSpec.getFormParams());
        }
        HttpRequestAttachment requestAttachment = requestAttachmentBuilder.build();
        new DefaultAttachmentProcessor().addAttachment((AttachmentData)requestAttachment, (AttachmentRenderer)new FreemarkerAttachmentRenderer(this.requestTemplatePath));
        Response response = filterContext.next(requestSpec, responseSpec);
        String attachmentName = Optional.ofNullable(this.responseAttachmentName).orElse(response.getStatusLine());
        HttpResponseAttachment responseAttachment = HttpResponseAttachment.Builder.create((String)attachmentName).setResponseCode(response.getStatusCode()).setHeaders(AllureRestAssured.toMapConverter((Iterable<? extends NameAndValue>)response.getHeaders(), hiddenHeaders)).setBody(prettifier.getPrettifiedBodyIfPossible((ResponseOptions)response, response.getBody())).build();
        new DefaultAttachmentProcessor().addAttachment((AttachmentData)responseAttachment, (AttachmentRenderer)new FreemarkerAttachmentRenderer(this.responseTemplatePath));
        return response;
    }

    private static Map<String, String> toMapConverter(Iterable<? extends NameAndValue> items, Set<String> toHide) {
        HashMap<String, String> result = new HashMap<String, String>();
        items.forEach(h -> result.put(h.getName(), toHide.contains(h.getName()) ? HIDDEN_PLACEHOLDER : h.getValue()));
        return result;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

