/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.readline;

import io.termd.core.readline.LineStatus;
import io.termd.core.util.Helper;
import io.termd.core.util.Vector;
import io.termd.core.util.Wcwidth;
import java.util.Arrays;
import java.util.function.Consumer;

public class LineBuffer {
    private int[] data;
    private int cursor;
    private int size;

    public LineBuffer() {
        this.data = new int[1000];
    }

    private LineBuffer(LineBuffer that) {
        this.data = (int[])that.data.clone();
        this.cursor = that.cursor;
        this.size = that.size;
    }

    public int[] toArray() {
        return Arrays.copyOf(this.data, this.size);
    }

    public int getAt(int index) {
        if (index < 0 | index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[index];
    }

    public LineBuffer insert(String s) {
        return this.insert(Helper.toCodePoints(s));
    }

    public LineBuffer insert(int ... codePoints) {
        for (int cp : codePoints) {
            this.insert(cp);
        }
        return this;
    }

    public LineBuffer insert(int cp) {
        int w = Wcwidth.of(cp);
        if (w == -1) {
            if (cp != 10) {
                throw new IllegalArgumentException("LineBuffer can only contain \n control char");
            }
        } else if (w != 1) {
            throw new IllegalArgumentException("LineBuffer cannot contain chars of width!=1 for the moment");
        }
        if (this.cursor < this.size) {
            System.arraycopy(this.data, this.cursor, this.data, this.cursor + 1, this.size - this.cursor);
        }
        this.data[this.cursor++] = cp;
        ++this.size;
        return this;
    }

    public LineStatus.Ext insertEscaped(int ... codePoints) {
        LineStatus.Ext status = new LineStatus.Ext();
        Helper.consumeTo(this.toArray(), status);
        status.buffer.clear();
        block14: for (int cp : codePoints) {
            if (cp < 32) {
                throw new UnsupportedOperationException("todo");
            }
            switch (status.getQuote()) {
                case 34: {
                    switch (cp) {
                        case 34: 
                        case 92: {
                            if (!status.isEscaping()) {
                                status.accept(92);
                            }
                            status.accept(cp);
                            continue block14;
                        }
                    }
                    if (status.isEscaping()) continue block14;
                    status.accept(cp);
                    continue block14;
                }
                case 39: {
                    switch (cp) {
                        case 39: {
                            status.accept(39);
                            status.accept(92);
                            status.accept(cp);
                            status.accept(39);
                            continue block14;
                        }
                    }
                    status.accept(cp);
                    continue block14;
                }
                case 0: {
                    if (status.isEscaping()) {
                        status.accept(cp);
                        continue block14;
                    }
                    switch (cp) {
                        case 32: 
                        case 34: 
                        case 39: 
                        case 92: {
                            status.accept(92);
                            status.accept(cp);
                            continue block14;
                        }
                    }
                    status.accept(cp);
                    continue block14;
                }
                default: {
                    throw new UnsupportedOperationException("Todo " + status.getQuote());
                }
            }
        }
        this.insert(status.buffer.stream().mapToInt(i -> i).toArray());
        return status;
    }

    public int delete(int delta) {
        if (delta > 0) {
            delta = Math.min(delta, this.size - this.cursor);
            System.arraycopy(this.data, this.cursor + delta, this.data, this.cursor, this.size - this.cursor + delta);
            this.size -= delta;
            return delta;
        }
        if (delta < 0) {
            delta = -Math.min(-delta, this.cursor);
            System.arraycopy(this.data, this.cursor, this.data, this.cursor + delta, this.size - this.cursor);
            this.size += delta;
            this.cursor += delta;
            return -delta;
        }
        return 0;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        int n = this.size = size >= 0 ? size : 0;
        if (this.cursor > size) {
            this.cursor = size;
        }
    }

    public int getCursor() {
        return this.cursor;
    }

    public LineBuffer setCursor(int next) {
        this.cursor = next < 0 ? 0 : (next > this.size ? this.size : next);
        return this;
    }

    public LineBuffer copy() {
        return new LineBuffer(this);
    }

    public void clear() {
        this.size = 0;
        this.cursor = 0;
    }

    public int moveCursor(int delta) {
        int prev = this.cursor;
        this.setCursor(this.cursor + delta);
        return this.cursor - prev;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            sb.appendCodePoint(this.data[i]);
        }
        return sb.toString();
    }

    public Vector getCursorPosition(int width) {
        return this.getPosition(this.cursor, width);
    }

    public Vector getPosition(int offset, int width) {
        if (offset > this.size) {
            throw new IndexOutOfBoundsException("Offset cannot bebe greater than the buffer size");
        }
        return Helper.computePosition(this.data, new Vector(0, 0), offset, width);
    }

    private int findEndOfLine(int offset) {
        while (offset < this.size) {
            int c = this.data[offset];
            int w = Wcwidth.of(c);
            if (w == -1) {
                if (c == 10) break;
                throw new UnsupportedOperationException();
            }
            ++offset;
        }
        return offset;
    }

    public void update(LineBuffer dst, Consumer<int[]> out, int width) {
        new Update(out, width).perform(dst);
    }

    static /* synthetic */ int[] access$202(LineBuffer x0, int[] x1) {
        x0.data = x1;
        return x1;
    }

    private class Update {
        private final Consumer<int[]> out;
        private final int width;
        private int scrCol;
        private int scrRow;
        private int srcIdx;
        private int srcCol;
        private int srcRow;
        private int dstIdx;
        private int dstCol;
        private int dstRow;

        public Update(Consumer<int[]> out, int width) {
            this.out = out;
            this.width = width;
            this.scrCol = LineBuffer.this.getCursorPosition(width).x();
            this.scrRow = LineBuffer.this.getCursorPosition(width).y();
        }

        public void perform(LineBuffer dst) {
            while (this.dstIdx < dst.size) {
                boolean needGlitchCorrection;
                int eol = dst.findEndOfLine(this.dstIdx);
                boolean bl = needGlitchCorrection = this.dstIdx < eol;
                while (this.dstIdx < eol) {
                    int c = dst.data[this.dstIdx];
                    int w = Wcwidth.of(c);
                    if (w != 1) {
                        throw new UnsupportedOperationException();
                    }
                    if (this.srcIdx < LineBuffer.this.size && new Vector(this.srcCol, this.srcRow).equals(new Vector(this.dstCol, this.dstRow))) {
                        if (LineBuffer.this.data[this.srcIdx] == dst.data[this.dstIdx]) {
                            this.dstCol += w;
                            if (this.dstCol == this.width) {
                                this.dstCol = 0;
                                ++this.dstRow;
                            }
                        } else {
                            this.moveCursor(this.dstCol, this.dstRow);
                            this.out.accept(new int[]{c});
                            this.dstCol += w;
                            if (this.dstCol == this.width) {
                                this.dstCol = 0;
                            }
                            this.scrCol = this.dstCol;
                            this.scrRow = ++this.dstRow;
                        }
                        ++this.dstIdx;
                    } else {
                        this.moveCursor(this.dstCol, this.dstRow);
                        ++this.dstIdx;
                        this.out.accept(new int[]{c});
                        this.dstCol += w;
                        if (this.dstCol == this.width) {
                            this.dstCol = 0;
                        }
                        this.scrCol = this.dstCol;
                        this.scrRow = ++this.dstRow;
                    }
                    this.ensure(this.dstCol, this.dstRow);
                }
                if (needGlitchCorrection && this.dstCol == 0) {
                    this.out.accept(new int[]{32, 13});
                }
                if (this.dstIdx < dst.size) {
                    ++this.dstIdx;
                    this.dstCol = 0;
                    ++this.dstRow;
                    int _col = this.srcCol;
                    int _row = this.srcRow;
                    if (this.ensure(this.dstCol, this.dstRow)) {
                        this.moveCursor(_col, _row);
                        this.out.accept(new int[]{27, 91, 75});
                    }
                }
                while (this.scrRow < this.dstRow) {
                    this.out.accept(new int[]{10});
                    ++this.scrRow;
                    this.scrCol = 0;
                }
            }
            if (this.srcIdx < LineBuffer.this.size) {
                int _col = this.srcCol;
                int _row = this.srcRow;
                int count = 0;
                while (this.srcIdx < LineBuffer.this.size) {
                    int c = LineBuffer.this.data[this.srcIdx++];
                    if (c == 10) {
                        if (count > 0) {
                            this.moveCursor(_col, _row);
                            this.out.accept(new int[]{27, 91, 75});
                            count = 0;
                        }
                        this.srcCol = 0;
                        _col = 0;
                        _row = ++this.srcRow;
                        continue;
                    }
                    int w = Wcwidth.of(c);
                    if (w != 1) {
                        throw new UnsupportedOperationException();
                    }
                    ++this.srcCol;
                    ++count;
                    if (this.srcCol != this.width) continue;
                    if (count > 0) {
                        this.moveCursor(_col, _row);
                        this.out.accept(new int[]{27, 91, 75});
                        count = 0;
                        this.srcCol = 0;
                        _col = 0;
                        _row = ++this.srcRow;
                        continue;
                    }
                    this.srcCol = 0;
                    ++this.srcRow;
                }
                if (count > 0) {
                    this.moveCursor(_col, _row);
                    this.out.accept(new int[]{27, 91, 75});
                }
            }
            this.moveCursor(dst.getCursorPosition(this.width).x(), dst.getCursorPosition(this.width).y());
            LineBuffer.access$202(LineBuffer.this, (int[])dst.data.clone());
            LineBuffer.this.cursor = dst.cursor;
            LineBuffer.this.size = dst.size;
        }

        private boolean ensure(int col, int row) {
            boolean ret = false;
            while (this.srcIdx < LineBuffer.this.size && this.srcRow <= row && (this.srcRow != row || this.srcCol < col)) {
                int c = LineBuffer.this.data[this.srcIdx];
                int w = Wcwidth.of(c);
                if (w == 1) {
                    ret = true;
                    ++this.srcCol;
                    if (this.srcCol == this.width) {
                        ++this.srcRow;
                        this.srcCol = 0;
                    }
                } else if (c == 10) {
                    this.srcCol = 0;
                    ++this.srcRow;
                } else {
                    throw new UnsupportedOperationException();
                }
                ++this.srcIdx;
            }
            return ret;
        }

        private void moveCursor(int col, int row) {
            if (this.scrCol != col) {
                if (col == 0) {
                    this.out.accept(new int[]{13});
                    this.scrCol = 0;
                } else {
                    while (this.scrCol != col) {
                        if (this.scrCol < col) {
                            ++this.scrCol;
                            this.out.accept(new int[]{27, 91, 49, 67});
                            continue;
                        }
                        --this.scrCol;
                        this.out.accept(new int[]{8});
                    }
                }
            }
            while (this.scrRow != row) {
                if (row < this.scrRow) {
                    --this.scrRow;
                    this.out.accept(new int[]{27, 91, 49, 65});
                    continue;
                }
                ++this.scrRow;
                this.out.accept(new int[]{27, 91, 49, 66});
            }
        }
    }
}

