/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.term;

import io.termd.core.util.Helper;
import java.util.LinkedList;
import java.util.function.Consumer;

public class EvalContext {
    final LinkedList<String> stack = new LinkedList();
    final String[] parameters;
    private final Consumer<int[]> result;

    public EvalContext(String[] parameters, Consumer<int[]> result) {
        this.parameters = parameters;
        this.result = result;
    }

    public EvalContext(String[] parameters, StringBuilder result) {
        this.parameters = parameters;
        this.result = codePoint -> Helper.appendCodePoints(codePoint, result);
    }

    public int getParametersLength() {
        return this.parameters.length;
    }

    public String getParameter(int index) {
        return this.parameters[index];
    }

    public void setParameter(int index, String value) {
        this.parameters[index] = value;
    }

    public String pop() {
        return this.stack.pop();
    }

    public EvalContext push(String s) {
        this.stack.push(s);
        return this;
    }

    public void writeString(String s) {
        this.result.accept(s.codePoints().toArray());
    }

    public void writeNumber(int number) {
        this.writeString(Integer.toString(number));
    }

    public void writeCodePoint(int codePoint) {
        this.result.accept(new int[]{codePoint});
    }
}

