/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.term;

import io.termd.core.term.EvalContext;
import io.termd.core.term.OpCode;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public class Sequence
implements Iterable<OpCode> {
    private final List<OpCode> value;

    public Sequence(List<OpCode> value) {
        this.value = value;
    }

    public Sequence(String s) {
        this.value = Collections.singletonList(new OpCode.Literal(s));
    }

    public int size() {
        return this.value.size();
    }

    public String eval(String ... parameters) {
        StringBuilder buffer = new StringBuilder();
        this.eval(parameters, buffer);
        return buffer.toString();
    }

    public void eval(String[] parameters, StringBuilder result) {
        this.eval(new EvalContext(parameters, result));
    }

    public void eval(String[] parameters, Consumer<int[]> result) {
        this.eval(new EvalContext(parameters, result));
    }

    public void eval(EvalContext context) {
        for (OpCode op : this.value) {
            op.eval(context);
        }
    }

    @Override
    public Iterator<OpCode> iterator() {
        return this.value.iterator();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (OpCode op : this.value) {
            op.toString(buffer);
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Sequence) {
            Sequence that = (Sequence)obj;
            return this.value.equals(that.value);
        }
        return false;
    }
}

