/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Naming {
    private static Stream<String> normalize(List<String> word) {
        if (word == null) {
            return Stream.empty();
        }
        return word.stream().filter(e -> e != null).map(e -> e.trim()).filter(e -> !e.isEmpty());
    }

    private static String normalize(String name) {
        if (name == null) {
            return "";
        }
        return name.trim();
    }

    public static String toPascalCase(List<String> words) {
        return Naming.normalize(words).map(e -> Character.toUpperCase(e.charAt(0)) + e.substring(1)).collect(Collectors.joining());
    }

    public static List<String> toWordsByPascalCase(String name) {
        if ((name = Naming.normalize(name)).isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(name.replaceAll("([^A-Z])([A-Z])", "$1 $2").split("\\s+"));
    }

    public static String toCamelCase(List<String> words) {
        List tmp = Naming.normalize(words).map(e -> Character.toUpperCase(e.charAt(0)) + e.substring(1)).collect(Collectors.toList());
        if (tmp.isEmpty()) {
            return "";
        }
        tmp.set(0, ((String)tmp.get(0)).toLowerCase());
        return tmp.stream().collect(Collectors.joining());
    }

    public static List<String> toWordsByCamelCase(String name) {
        if ((name = Naming.normalize(name)).isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(name.replaceAll("([^A-Z])([A-Z])", "$1 $2").split("\\s+"));
    }

    public static String toUnderscores(List<String> words) {
        return Naming.normalize(words).collect(Collectors.joining("_"));
    }

    public static List<String> toWordsByUnderscores(String name) {
        return Arrays.asList(Naming.normalize(name).split("\\_"));
    }

    public static String toDashes(List<String> words) {
        return Naming.normalize(words).collect(Collectors.joining("-"));
    }

    public static List<String> toWordsByDashes(String name) {
        return Arrays.asList(Naming.normalize(name).split("\\-"));
    }
}

