/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons.bytes;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class AbstractDataFormat {
    AbstractDataFormat() {
    }

    protected Optional<Method> getter(Class<?> clazz, String fieldName, boolean ignoreNotFound) {
        String methodNameGet = "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        List methods = Stream.of(clazz.getDeclaredMethods()).filter(e -> e.getName().equals(methodNameGet)).filter(e -> !e.getReturnType().equals(Void.TYPE)).filter(e -> e.getParameterCount() == 0).collect(Collectors.toList());
        if (methods.size() == 0) {
            if (ignoreNotFound) {
                return Optional.ofNullable(null);
            }
            throw new IllegalArgumentException("not found getter of " + fieldName + " field");
        }
        if (methods.size() > 1) {
            throw new IllegalArgumentException(methodNameGet + "() is ambiguous");
        }
        return Optional.of((Method)methods.get(0));
    }

    protected Optional<Method> setter(Class<?> clazz, String fieldName, boolean ignoreNotFound) {
        String methodName = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        List methods = Stream.of(clazz.getDeclaredMethods()).filter(e -> e.getName().equals(methodName)).filter(e -> e.getParameterCount() == 1).collect(Collectors.toList());
        if (methods.size() == 0) {
            if (ignoreNotFound) {
                return Optional.ofNullable(null);
            }
            throw new IllegalArgumentException("not found setter of " + fieldName + " field");
        }
        if (methods.size() > 1) {
            throw new IllegalArgumentException(methodName + "() is ambiguous");
        }
        return Optional.of((Method)methods.get(0));
    }
}

