/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons.excel;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import me.saro.commons.NullOutputStream;
import me.saro.commons.excel.Excel;
import me.saro.commons.excel.ExcelCell;
import me.saro.commons.excel.ExcelRow;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class BasicExcel
implements Excel {
    private final Workbook book;
    private final boolean bulk;
    private int rowIndex = -1;
    private Sheet sheet;
    private ExcelRow row;

    protected BasicExcel(Workbook book) {
        this.book = book;
        this.bulk = book.getClass().getName().equals(SXSSFWorkbook.class.getName());
        this.moveSheet(0);
    }

    @Override
    public Sheet getPoiSheet() {
        return this.sheet;
    }

    @Override
    public Excel moveSheet(int index) {
        if (this.book.getNumberOfSheets() <= index) {
            int need = index + 1 - this.book.getNumberOfSheets();
            for (int i = 0; i < need; ++i) {
                this.book.createSheet();
            }
        }
        this.sheet = this.book.getSheetAt(index);
        return this;
    }

    @Override
    public Excel moveNextRow() {
        this.row = new ExcelRow(this, ++this.rowIndex);
        return this;
    }

    @Override
    public ExcelRow getRow() {
        return this.row;
    }

    @Override
    public ExcelRow getRow(int rowIndex) {
        return new ExcelRow(this, rowIndex);
    }

    @Override
    public ExcelCell getCell(int rowIndex, int cellIndex) {
        return new ExcelCell(new ExcelRow(this, rowIndex), cellIndex);
    }

    @Override
    public Excel output(OutputStream os) throws IOException {
        this.book.write(os);
        os.flush();
        return this;
    }

    @Override
    public Excel autoSizeColumn() {
        if (this.bulk) {
            throw new RuntimeException("bulk mode does not support autoSizeColumn");
        }
        HashSet<Integer> set = new HashSet<Integer>();
        for (Row row : this.sheet) {
            for (Cell cell : row) {
                set.add(cell.getColumnIndex());
            }
        }
        for (Integer i : set) {
            this.sheet.autoSizeColumn(i.intValue());
        }
        return this;
    }

    @Override
    public Excel autoSizeColumn(int cellIndex) {
        if (this.bulk) {
            throw new RuntimeException("bulk mode does not support autoSizeColumn");
        }
        this.sheet.autoSizeColumn(cellIndex);
        return this;
    }

    @Override
    public Excel save(File file, boolean overwrite) throws IOException {
        if (file.exists()) {
            if (!overwrite) {
                throw new IOException("file exists : " + file.getAbsolutePath());
            }
            file.delete();
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.book.write((OutputStream)fos);
            fos.flush();
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        try (NullOutputStream bos = new NullOutputStream();){
            this.book.write((OutputStream)bos);
            bos.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.book.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isBulk() {
        return this.bulk;
    }
}

