/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons.ftp;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.function.Predicate;
import me.saro.commons.ftp.FTPS;
import me.saro.commons.ftp.SFTP;

public interface FTP
extends Closeable {
    public static FTP openFTP(InetAddress host, int port, String user, String pass) throws IOException {
        return new FTPS(host, port, user, pass, false);
    }

    public static FTP openFTP(String host, int port, String user, String pass) throws IOException {
        return new FTPS(InetAddress.getByName(host), port, user, pass, false);
    }

    public static FTP openFTPS(InetAddress host, int port, String user, String pass) throws IOException {
        return new FTPS(host, port, user, pass, true);
    }

    public static FTP openFTPS(String host, int port, String user, String pass) throws IOException {
        return new FTPS(InetAddress.getByName(host), port, user, pass, true);
    }

    public static FTP openSFTP(String host, int port, String user, String pass) throws IOException {
        return new SFTP(host, port, user, pass);
    }

    default public boolean cd(String pathname) throws IOException {
        return this.path(pathname);
    }

    public boolean path(String var1) throws IOException;

    public String path() throws IOException;

    default public String pwd() throws IOException {
        return this.path();
    }

    public List<String> listFiles(Predicate<String> var1) throws IOException;

    public List<String> listFiles() throws IOException;

    public List<String> listDirectories(Predicate<String> var1) throws IOException;

    public List<String> listDirectories() throws IOException;

    public boolean hasFile(String var1) throws IOException;

    public boolean hasDirectory(String var1) throws IOException;

    public boolean delete(String var1) throws IOException;

    public boolean send(String var1, File var2) throws IOException;

    default public boolean send(File localFile) throws IOException {
        return this.send(localFile.getName(), localFile);
    }

    public boolean recv(String var1, File var2) throws IOException;

    default public void recv(List<String> remoteFilenameList, File localDirectory) throws IOException {
        if (!localDirectory.isDirectory()) {
            throw new IOException("[" + localDirectory.getAbsolutePath() + "] is not Directory");
        }
        for (String file : remoteFilenameList) {
            if (this.recv(file, new File(localDirectory, file))) continue;
            throw new IOException("fail recv file [" + this.path() + "/" + file + "]");
        }
    }

    public boolean mkdir(String var1) throws IOException;

    @Override
    public void close();
}

