/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons.ftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import me.saro.commons.ftp.FTP;

public class SFTP
implements FTP {
    final ChannelSftp sftp;
    final Session session;

    public SFTP(String host, int port, String user, String pass) throws IOException {
        try {
            this.session = new JSch().getSession(user, host, port);
            this.session.setPassword(pass);
            this.session.setConfig("StrictHostKeyChecking", "no");
            this.session.connect();
            this.sftp = (ChannelSftp)this.session.openChannel("sftp");
            this.sftp.connect();
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean path(String pathname) throws IOException {
        try {
            this.sftp.cd(pathname);
        }
        catch (SftpException e) {
            return false;
        }
        return true;
    }

    @Override
    public String path() throws IOException {
        try {
            return this.sftp.pwd();
        }
        catch (SftpException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> list(Predicate<ChannelSftp.LsEntry> filter) throws IOException {
        try {
            ArrayList<String> list = new ArrayList<String>();
            this.sftp.ls(this.path(), e -> {
                if (filter.test(e)) {
                    list.add(e.getFilename());
                }
                return 0;
            });
            return list;
        }
        catch (SftpException e2) {
            throw new IOException(e2);
        }
    }

    @Override
    public List<String> listFiles(Predicate<String> filter) throws IOException {
        return this.list(e -> !e.getAttrs().isDir() && filter.test(e.getFilename()));
    }

    @Override
    public List<String> listFiles() throws IOException {
        return this.list(e -> !e.getAttrs().isDir());
    }

    @Override
    public List<String> listDirectories(Predicate<String> filter) throws IOException {
        return this.list(e -> e.getAttrs().isDir() && !e.getFilename().matches("[\\.]{1,2}") && filter.test(e.getFilename()));
    }

    @Override
    public List<String> listDirectories() throws IOException {
        return this.list(e -> e.getAttrs().isDir() && !e.getFilename().matches("[\\.]{1,2}"));
    }

    @Override
    public boolean hasFile(String filename) throws IOException {
        try {
            return Optional.ofNullable(this.sftp.lstat(this.path() + "/" + filename)).filter(e -> !e.isDir()).isPresent();
        }
        catch (SftpException e2) {
            if (e2.id == 2) {
                return false;
            }
            throw new IOException(e2);
        }
    }

    @Override
    public boolean hasDirectory(String directoryname) throws IOException {
        try {
            return Optional.ofNullable(this.sftp.lstat(this.path() + "/" + directoryname)).filter(e -> e.isDir()).isPresent();
        }
        catch (SftpException e2) {
            if (e2.id == 2) {
                return false;
            }
            throw new IOException(e2);
        }
    }

    @Override
    public boolean delete(String filename) throws IOException {
        try {
            if (this.hasFile(filename)) {
                this.sftp.rm(filename);
                return true;
            }
            if (this.hasDirectory(filename)) {
                this.sftp.rmdir(filename);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean send(String saveFilename, File localFile) throws IOException {
        try (FileInputStream input = new FileInputStream(localFile);){
            this.sftp.put((InputStream)input, saveFilename);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public boolean recv(String remoteFilename, File localFile) throws IOException {
        boolean bl;
        if (!this.hasFile(remoteFilename)) {
            return false;
        }
        if (localFile.exists()) {
            localFile.delete();
        }
        FileOutputStream fos = new FileOutputStream(localFile);
        try {
            this.sftp.get(remoteFilename, (OutputStream)fos);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        fos.close();
        return bl;
    }

    @Override
    public boolean mkdir(String createDirectoryName) throws IOException {
        try {
            this.sftp.mkdir(createDirectoryName);
        }
        catch (SftpException e) {
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        try {
            this.sftp.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.session.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ChannelSftp getSftp() {
        return this.sftp;
    }
}

