/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons.ssh;

import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.saro.commons.function.ThrowableConsumer;

public class SSHShell
implements Closeable {
    final String charset;
    final Session session;
    final ChannelShell shell;
    final OutputStream outputStream;
    final InputStream inputStream;
    final InputStreamReader inputStreamReader;
    final BufferedReader bufferedReader;
    final Thread readLineThread;

    private SSHShell(String host, int port, String user, String pass, String charset, ThrowableConsumer<String> readLines) throws IOException {
        try {
            this.charset = charset;
            this.session = new JSch().getSession(user, host, port);
            this.session.setPassword(pass);
            this.session.setConfig("StrictHostKeyChecking", "no");
            this.session.connect();
            this.shell = (ChannelShell)this.session.openChannel("shell");
            this.shell.connect();
            this.inputStream = this.shell.getInputStream();
            this.outputStream = this.shell.getOutputStream();
            this.inputStreamReader = new InputStreamReader(this.inputStream, charset);
            this.bufferedReader = new BufferedReader(this.inputStreamReader);
            this.readLineThread = this.getReadLineThread(readLines);
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
    }

    public static SSHShell open(String host, int port, String user, String pass, String charset, ThrowableConsumer<String> readLines) throws IOException {
        return new SSHShell(host, port, user, pass, charset, readLines);
    }

    private Thread getReadLineThread(ThrowableConsumer<String> readLines) {
        Thread thread = new Thread(() -> {
            block2: {
                try {
                    this.bufferedReader.lines().forEach(ThrowableConsumer.runtime(readLines));
                }
                catch (Exception e) {
                    if (e instanceof UncheckedIOException) break block2;
                    throw new RuntimeException(e);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    public void cmd(String ... cmds) throws IOException {
        this.outputStream.write(Optional.ofNullable(cmds).filter(e -> ((String[])e).length > 0).map(Stream::of).map(e -> e.collect(Collectors.joining("\n", "", "\n"))).orElseThrow(() -> new IllegalArgumentException("there is no command")).getBytes(this.charset));
        this.outputStream.flush();
    }

    public void cmdExitAndJoinEOF() throws IOException, InterruptedException {
        try {
            this.cmd("exit");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.joinEOF();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void joinEOF() throws InterruptedException {
        if (this.readLineThread.isAlive()) {
            this.readLineThread.join();
        }
    }

    public boolean isConnected() {
        return this.shell.isConnected();
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.shell.isEOF()) {
                this.cmdExitAndJoinEOF();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try (OutputStream os = this.outputStream;
             BufferedReader br = this.bufferedReader;
             InputStreamReader isr = this.inputStreamReader;){
            InputStream is = this.inputStream;
            if (is != null) {
                is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.readLineThread.isAlive()) {
                this.readLineThread.interrupt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.shell.isConnected()) {
                this.shell.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.session.isConnected()) {
                this.session.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

