/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons.web;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import me.saro.commons.Converter;
import me.saro.commons.Files;
import me.saro.commons.function.ThrowableConsumer;
import me.saro.commons.function.ThrowableFunction;
import me.saro.commons.json.JsonReader;
import me.saro.commons.web.BasicWeb;
import me.saro.commons.web.WebResult;

public interface Web {
    public static Web get(String url) {
        return new BasicWeb(url, "GET");
    }

    public static Web post(String url) {
        return new BasicWeb(url, "POST");
    }

    public static Web put(String url) {
        return new BasicWeb(url, "PUT");
    }

    public static Web patch(String url) {
        return new BasicWeb(url, "PATCH");
    }

    public static Web delete(String url) {
        return new BasicWeb(url, "DELETE");
    }

    public String getRequestCharset();

    public String getResponseCharset();

    public static Web custom(String url, String method) {
        return new BasicWeb(url, method);
    }

    public Web setConnectTimeout(int var1);

    public Web setReadTimeout(int var1);

    public Web setRequestCharset(String var1);

    public Web setResponseCharset(String var1);

    public Web setIgnoreCertificate(boolean var1);

    public Web addUrlParameter(String var1, String var2);

    public Web setHeader(String var1, String var2);

    public Web writeBody(byte[] var1);

    public Web writeBodyParameter(String var1, String var2);

    public <R> WebResult<R> toCustom(WebResult<R> var1, ThrowableFunction<InputStream, R> var2);

    default public <R> WebResult<R> toCustom(ThrowableFunction<InputStream, R> function) {
        return this.toCustom(new WebResult(), function);
    }

    default public WebResult<Map<String, Object>> toMapByJsonObject() {
        return this.toJsonTypeReference(new TypeReference<Map<String, Object>>(){});
    }

    default public WebResult<List<Map<String, Object>>> toMapListByJsonArray() {
        return this.toJsonTypeReference(new TypeReference<List<Map<String, Object>>>(){});
    }

    default public WebResult<JsonReader> toJsonReader() {
        return this.toCustom(is -> new JsonReader(Converter.toStringNotClose(is, this.getResponseCharset())));
    }

    default public <T> WebResult<T> toJsonTypeReference(TypeReference<T> typeReference) {
        return this.toCustom(is -> new ObjectMapper().readValue(is, typeReference));
    }

    default public WebResult<String> toPlainText() {
        return this.toCustom(is -> Converter.toStringNotClose(is, this.getResponseCharset()));
    }

    default public WebResult<File> saveFile(File file, boolean overwrite) {
        return this.toCustom(is -> {
            Files.createFile(file, overwrite, is);
            return file;
        });
    }

    default public WebResult<String> readRawResultStream(ThrowableConsumer<InputStream> reader) {
        return this.toCustom(is -> {
            reader.accept((InputStream)is);
            return "OK";
        });
    }

    default public Web setContentType(String value) {
        return this.setHeader("Content-Type", value);
    }

    default public Web setContentTypeApplicationJson() {
        return this.setHeader("Content-Type", "application/json");
    }

    default public Web writeBody(String text) {
        try {
            return this.writeBody(text.getBytes(this.getRequestCharset()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    default public Web writeJsonByClass(Object toJsonObject) {
        return this.writeBody(Converter.toJson(toJsonObject));
    }
}

