/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.core.io;

import com.mysql.cj.core.io.DefaultValueFactory;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BigDecimalValueFactory
extends DefaultValueFactory<BigDecimal> {
    int scale;
    boolean hasScale;

    public BigDecimalValueFactory() {
    }

    public BigDecimalValueFactory(int scale) {
        this.scale = scale;
        this.hasScale = true;
    }

    private BigDecimal adjustResult(BigDecimal d) {
        if (this.hasScale) {
            try {
                return d.setScale(this.scale);
            }
            catch (ArithmeticException ex) {
                return d.setScale(this.scale, 4);
            }
        }
        return d;
    }

    @Override
    public BigDecimal createFromBigInteger(BigInteger i) {
        return this.adjustResult(new BigDecimal(i));
    }

    @Override
    public BigDecimal createFromLong(long l) {
        return this.adjustResult(BigDecimal.valueOf(l));
    }

    @Override
    public BigDecimal createFromBigDecimal(BigDecimal d) {
        return this.adjustResult(d);
    }

    @Override
    public BigDecimal createFromDouble(double d) {
        return this.adjustResult(BigDecimal.valueOf(d));
    }

    @Override
    public String getTargetTypeName() {
        return BigDecimal.class.getName();
    }
}

