/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BaselineControlMethod
extends DavMethodBase {
    private static Logger log = LoggerFactory.getLogger(BaselineControlMethod.class);

    public BaselineControlMethod(String uri) {
        super(uri);
    }

    public BaselineControlMethod(String uri, String baselineHref) throws IOException {
        super(uri);
        if (baselineHref != null) {
            try {
                Document document = DomUtil.createDocument();
                Element el = DomUtil.addChildElement(document, "baseline-control", DeltaVConstants.NAMESPACE);
                el.appendChild(DomUtil.hrefToXml(baselineHref, document));
                this.setRequestBody(document);
            }
            catch (ParserConfigurationException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public String getName() {
        return "BASELINE-CONTROL";
    }

    protected boolean isSuccess(int statusCode) {
        return statusCode == 200;
    }
}

