/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.data;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.base.file.BinaryDataFile;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.StateMgrData;
import org.apache.jena.dboe.transaction.txn.TransactionalComponentLifecycle;
import org.apache.jena.dboe.transaction.txn.TxnId;
import org.apache.jena.query.ReadWrite;

public class TransBinaryDataFile
extends TransactionalComponentLifecycle<TxnBinFile>
implements BinaryDataFile {
    private final FileState fileState;
    private final AtomicLong committedLength;
    private final BinaryDataFile binFile;
    private boolean recoveryAction = false;

    public TransBinaryDataFile(BinaryDataFile binFile, ComponentId cid, BufferChannel bufferChannel) {
        super(cid);
        this.fileState = new FileState(bufferChannel, 0L, 0L);
        this.binFile = binFile;
        if (!binFile.isOpen()) {
            binFile.open();
        }
        this.committedLength = new AtomicLong(binFile.length());
    }

    public void startRecovery() {
        this.recoveryAction = false;
    }

    public void recover(ByteBuffer ref) {
        this.fileState.setState(ref);
        this.committedLength.set(this.fileState.length());
        this.recoveryAction = true;
    }

    public void finishRecovery() {
        if (this.recoveryAction) {
            long length = this.committedLength.get();
            this.binFile.truncate(length);
            this.binFile.sync();
            this.committedLength.set(this.binFile.length());
            this.recoveryAction = false;
        }
    }

    public void cleanStart() {
    }

    protected TxnBinFile _begin(ReadWrite readWrite, TxnId txnId) {
        return this.createState();
    }

    private TxnBinFile createState() {
        long xLength = this.committedLength.get();
        return new TxnBinFile(xLength);
    }

    protected TxnBinFile _promote(TxnId txnId, TxnBinFile txnResetState) {
        return this.createState();
    }

    protected ByteBuffer _commitPrepare(TxnId txnId, TxnBinFile txnResetState) {
        this.binFile.sync();
        this.fileState.length(this.binFile.length());
        return this.fileState.getState();
    }

    protected void _commit(TxnId txnId, TxnBinFile txnResetState) {
        if (this.isWriteTxn()) {
            this.fileState.writeState();
            this.committedLength.set(this.binFile.length());
        }
    }

    protected void _commitEnd(TxnId txnId, TxnBinFile state) {
    }

    protected void _abort(TxnId txnId, TxnBinFile txnResetState) {
        if (this.isWriteTxn()) {
            long x = this.committedLength.get();
            if (txnResetState.length != x) {
                Log.warn((Object)((Object)this), (String)String.format("Mismatch: state.length = %d,  committedLength = %d", txnResetState.length != x));
            }
            this.binFile.truncate(x);
            this.binFile.sync();
        }
    }

    protected void _complete(TxnId txnId, TxnBinFile state) {
    }

    protected void _shutdown() {
    }

    public void open() {
        if (!this.binFile.isOpen()) {
            this.binFile.open();
        }
    }

    public boolean isOpen() {
        return this.binFile.isOpen();
    }

    public int read(long posn, byte[] b, int start, int length) {
        this.checkTxn();
        if (this.isReadTxn()) {
            this.checkRead(posn);
        }
        return this.binFile.read(posn, b, start, length);
    }

    private void checkRead(long posn) {
        if (posn > ((TxnBinFile)this.getDataState()).length) {
            IO.exception((String)("Out of bounds: (limit " + ((TxnBinFile)this.getDataState()).length + ") " + posn));
        }
    }

    public long write(byte[] b, int start, int length) {
        this.requireWriteTxn();
        return this.binFile.write(b, start, length);
    }

    public void truncate(long size) {
        this.requireWriteTxn();
        TxnBinFile state = (TxnBinFile)this.getDataState();
        if (size < state.length) {
            throw new RuntimeIOException("truncate(" + size + ") to smaller than commited length " + state.length);
        }
        this.binFile.truncate(size);
    }

    public void sync() {
        this.requireWriteTxn();
    }

    public void close() {
        this.fileState.close();
        this.binFile.close();
    }

    public long length() {
        super.checkTxn();
        if (this.isReadTxn()) {
            return ((TxnBinFile)this.getDataState()).length;
        }
        return this.binFile.length();
    }

    public boolean isEmpty() {
        super.checkTxn();
        return this.binFile.isEmpty();
    }

    static class FileState
    extends StateMgrData {
        private static int idxLength = 0;

        FileState(BufferChannel bufferChannel, long length, long position) {
            super(bufferChannel, new long[]{length, position});
        }

        long length() {
            return this.get(idxLength);
        }

        void length(long len) {
            this.set(idxLength, len);
        }
    }

    static class TxnBinFile {
        final long length;

        TxnBinFile(long length) {
            this.length = length;
        }
    }
}

