/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.state.internals.AbstractSegments;
import org.apache.kafka.streams.state.internals.TimestampedSegment;

class TimestampedSegments
extends AbstractSegments<TimestampedSegment> {
    TimestampedSegments(String name, long retentionPeriod, long segmentInterval) {
        super(name, retentionPeriod, segmentInterval);
    }

    @Override
    public TimestampedSegment getOrCreateSegment(long segmentId, InternalProcessorContext context) {
        if (this.segments.containsKey(segmentId)) {
            return (TimestampedSegment)this.segments.get(segmentId);
        }
        TimestampedSegment newSegment = new TimestampedSegment(this.segmentName(segmentId), this.name, segmentId);
        if (this.segments.put(segmentId, newSegment) != null) {
            throw new IllegalStateException("TimestampedSegment already exists. Possible concurrent access.");
        }
        newSegment.openDB(context);
        return newSegment;
    }
}

