/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.install;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.util.artifact.SubArtifact;

@Mojo(name="install", defaultPhase=LifecyclePhase.INSTALL, threadSafe=true)
public class InstallMojo
extends AbstractMojo {
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${plugin}", required=true, readonly=true)
    private PluginDescriptor pluginDescriptor;
    @Parameter(defaultValue="false", property="installAtEnd")
    private boolean installAtEnd;
    @Parameter(property="maven.install.skip", defaultValue="false")
    private boolean skip;
    private static final String INSTALL_PROCESSED_MARKER = InstallMojo.class.getName() + ".processed";

    private void putState(State state) {
        this.getPluginContext().put(INSTALL_PROCESSED_MARKER, state.name());
    }

    private State getState(MavenProject project) {
        Map pluginContext = this.session.getPluginContext(this.pluginDescriptor, project);
        return State.valueOf((String)pluginContext.get(INSTALL_PROCESSED_MARKER));
    }

    private boolean hasState(MavenProject project) {
        Map pluginContext = this.session.getPluginContext(this.pluginDescriptor, project);
        return pluginContext.containsKey(INSTALL_PROCESSED_MARKER);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping artifact installation");
            this.putState(State.SKIPPED);
        } else if (!this.installAtEnd) {
            this.installProject(this.project);
            this.putState(State.INSTALLED);
        } else {
            this.getLog().info((CharSequence)("Deferring install for " + this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion() + " at end"));
            this.putState(State.TO_BE_INSTALLED);
        }
        if (this.allProjectsMarked()) {
            for (MavenProject reactorProject : this.reactorProjects) {
                State state = this.getState(reactorProject);
                if (state != State.TO_BE_INSTALLED) continue;
                this.installProject(reactorProject);
            }
        }
    }

    private boolean allProjectsMarked() {
        for (MavenProject reactorProject : this.reactorProjects) {
            if (this.hasState(reactorProject)) continue;
            return false;
        }
        return true;
    }

    private void installProject(MavenProject project) throws MojoExecutionException, MojoFailureException {
        try {
            this.repositorySystem.install(this.session.getRepositorySession(), this.processProject(project));
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        catch (InstallationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private InstallRequest processProject(MavenProject project) {
        InstallRequest request = new InstallRequest();
        org.apache.maven.artifact.Artifact mavenMainArtifact = project.getArtifact();
        String packaging = project.getPackaging();
        File pomFile = project.getFile();
        boolean isPomArtifact = "pom".equals(packaging);
        boolean pomArtifactAttached = false;
        if (pomFile != null) {
            request.addArtifact(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)new ProjectArtifact(project)));
            pomArtifactAttached = true;
        }
        if (!isPomArtifact) {
            File file = mavenMainArtifact.getFile();
            if (file != null && file.isFile()) {
                Artifact mainArtifact = RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)mavenMainArtifact);
                request.addArtifact(mainArtifact);
                if (!pomArtifactAttached) {
                    for (Object metadata : mavenMainArtifact.getMetadataList()) {
                        if (!(metadata instanceof ProjectArtifactMetadata)) continue;
                        request.addArtifact(new SubArtifact(mainArtifact, "", "pom").setFile(((ProjectArtifactMetadata)metadata).getFile()));
                        pomArtifactAttached = true;
                    }
                }
            } else {
                if (!project.getAttachedArtifacts().isEmpty()) {
                    throw new IllegalArgumentException("The packaging plugin for this project did not assign a main file to the project but it has attachments. Change packaging to 'pom'.");
                }
                throw new IllegalArgumentException("The packaging for this project did not assign a file to the build artifact");
            }
        }
        if (!pomArtifactAttached) {
            throw new IllegalArgumentException("The POM could not be attached");
        }
        for (org.apache.maven.artifact.Artifact attached : project.getAttachedArtifacts()) {
            this.getLog().debug((CharSequence)("Attaching for install: " + attached.getId()));
            request.addArtifact(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)attached));
        }
        return request;
    }

    private static enum State {
        SKIPPED,
        INSTALLED,
        TO_BE_INSTALLED;

    }
}

