package org.apache.maven.shared.utils.io;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * Java7 feature detection
 *
 * @author Kristian Rosenvold
 */
public class Java7Support
{

    private static final boolean IS_JAVA7;

    private static Method isSymbolicLink;

    private static Method toPath;

    static
    {
        boolean isJava7x = true;
        try
        {
            Class<?> files = Thread.currentThread().getContextClassLoader().loadClass( "java.nio.file.Files" );
            Class<?> path = Thread.currentThread().getContextClassLoader().loadClass( "java.nio.file.Path" );
            isSymbolicLink = files.getMethod( "isSymbolicLink", path );
            toPath = File.class.getMethod( "toPath" );
        }
        catch ( ClassNotFoundException e )
        {
            isJava7x = false;
        }
        catch ( NoSuchMethodException e )
        {
            isJava7x = false;
        }
        IS_JAVA7 = isJava7x;
    }

    public static boolean isSymLink( File file )
    {
        try
        {
            Object path = toPath.invoke( file );
            return (Boolean) isSymbolicLink.invoke( null, path );
        }
        catch ( IllegalAccessException e )
        {
            throw new RuntimeException( e );
        }
        catch ( InvocationTargetException e )
        {
            throw new RuntimeException( e );
        }
    }

    public static boolean isJava7()
    {
        return IS_JAVA7;
    }
}
