/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.interest;

import boofcv.abst.feature.detect.interest.PointDetector;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.filter.derivative.ImageHessian;
import boofcv.alg.feature.detect.interest.EasyGeneralFeatureDetector;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.ImageGray;

public class GeneralToPointDetector<T extends ImageGray<T>, D extends ImageGray<D>>
extends EasyGeneralFeatureDetector<T, D>
implements PointDetector<T> {
    int totalSets;

    public GeneralToPointDetector(GeneralFeatureDetector<T, D> detector, Class<T> imageType, Class<D> derivType) {
        super(detector, imageType, derivType);
        if (detector.isDetectMaximums()) {
            ++this.totalSets;
        }
        if (detector.isDetectMinimums()) {
            ++this.totalSets;
        }
    }

    public GeneralToPointDetector(GeneralFeatureDetector<T, D> detector, ImageGradient<T, D> gradient, ImageHessian<D> hessian, Class<D> derivType) {
        super(detector, gradient, hessian, derivType);
        if (detector.isDetectMaximums()) {
            ++this.totalSets;
        }
        if (detector.isDetectMinimums()) {
            ++this.totalSets;
        }
    }

    @Override
    public void process(T input) {
        super.detect(input, null);
    }

    @Override
    public int totalSets() {
        return this.totalSets;
    }

    @Override
    public QueueCorner getPointSet(int which) {
        if (this.totalSets == 1) {
            if (this.detector.isDetectMinimums()) {
                return this.detector.getMinimums();
            }
            return this.detector.getMaximums();
        }
        if (which == 0) {
            return this.detector.getMinimums();
        }
        if (which == 1) {
            return this.detector.getMaximums();
        }
        throw new IllegalArgumentException("Invalid set index");
    }
}

