/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.moving;

import boofcv.alg.background.moving.BackgroundMovingBasic;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.core.image.FactoryGImageMultiBand;
import boofcv.core.image.GImageMultiBand;
import boofcv.core.image.border.BorderType;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.distort.Point2Transform2Model_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import georegression.struct.InvertibleTransform;

public class BackgroundMovingBasic_PL<T extends ImageGray<T>, Motion extends InvertibleTransform<Motion>>
extends BackgroundMovingBasic<Planar<T>, Motion> {
    protected Planar<GrayF32> background;
    protected InterpolatePixelMB<Planar<T>> interpolationInput;
    protected InterpolatePixelMB<Planar<GrayF32>> interpolationBG;
    protected GImageMultiBand backgroundWrapper;
    protected GImageMultiBand inputWrapper;
    protected float[] pixelInput;
    protected float[] pixelBack;

    public BackgroundMovingBasic_PL(float learnRate, float threshold, Point2Transform2Model_F32<Motion> transform, InterpolationType interpType, ImageType<Planar<T>> imageType) {
        super(learnRate, threshold, transform, imageType);
        this.interpolationInput = FactoryInterpolation.createPixelMB((double)0.0, (double)255.0, (InterpolationType)interpType, (BorderType)BorderType.EXTENDED, imageType);
        int numBands = imageType.getNumBands();
        this.background = new Planar(GrayF32.class, 1, 1, numBands);
        this.interpolationBG = FactoryInterpolation.createPixelMB((double)0.0, (double)255.0, (InterpolationType)interpType, (BorderType)BorderType.EXTENDED, (ImageType)ImageType.pl((int)numBands, GrayF32.class));
        this.interpolationBG.setImage(this.background);
        this.pixelInput = new float[numBands];
        this.pixelBack = new float[numBands];
        this.backgroundWrapper = FactoryGImageMultiBand.create((ImageType)ImageType.pl((int)numBands, GrayF32.class));
        this.backgroundWrapper.wrap(this.background);
        this.inputWrapper = FactoryGImageMultiBand.create(imageType);
    }

    public Planar<GrayF32> getBackground() {
        return this.background;
    }

    @Override
    public void initialize(int backgroundWidth, int backgroundHeight, Motion homeToWorld) {
        this.background.reshape(backgroundWidth, backgroundHeight);
        GImageMiscOps.fill(this.background, (double)3.4028234663852886E38);
        this.homeToWorld.set(homeToWorld);
        this.homeToWorld.invert(this.worldToHome);
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
    }

    @Override
    public void reset() {
        GImageMiscOps.fill(this.background, (double)3.4028234663852886E38);
    }

    @Override
    protected void updateBackground(int x0, int y0, int x1, int y1, Planar<T> frame) {
        this.transform.setModel((Object)this.worldToCurrent);
        this.interpolationInput.setImage(frame);
        int numBands = frame.getNumBands();
        float minusLearn = 1.0f - this.learnRate;
        for (int y = y0; y < y1; ++y) {
            int indexBG = this.background.startIndex + y * this.background.stride + x0;
            int x = x0;
            while (x < x1) {
                this.transform.compute((float)x, (float)y, this.work);
                if (this.work.x >= 0.0f && this.work.x < (float)frame.width && this.work.y >= 0.0f && this.work.y < (float)frame.height) {
                    this.interpolationInput.get(this.work.x, this.work.y, this.pixelInput);
                    this.backgroundWrapper.getF(indexBG, this.pixelBack);
                    for (int band = 0; band < numBands; ++band) {
                        float value = this.pixelInput[band];
                        float bg = this.pixelBack[band];
                        this.pixelBack[band] = bg == Float.MAX_VALUE ? value : minusLearn * bg + this.learnRate * value;
                    }
                    this.backgroundWrapper.setF(indexBG, this.pixelBack);
                }
                ++x;
                ++indexBG;
            }
        }
    }

    @Override
    protected void _segment(Motion currentToWorld, Planar<T> frame, GrayU8 segmented) {
        this.transform.setModel(currentToWorld);
        this.inputWrapper.wrap(frame);
        int numBands = this.background.getNumBands();
        float thresholdSq = (float)numBands * this.threshold * this.threshold;
        for (int y = 0; y < frame.height; ++y) {
            int indexFrame = frame.startIndex + y * frame.stride;
            int indexSegmented = segmented.startIndex + y * segmented.stride;
            int x = 0;
            while (x < frame.width) {
                block6: {
                    this.transform.compute((float)x, (float)y, this.work);
                    if (this.work.x >= 0.0f && this.work.x < (float)this.background.width && this.work.y >= 0.0f && this.work.y < (float)this.background.height) {
                        this.interpolationBG.get(this.work.x, this.work.y, this.pixelBack);
                        this.inputWrapper.getF(indexFrame, this.pixelInput);
                        double sumErrorSq = 0.0;
                        for (int band = 0; band < numBands; ++band) {
                            float bg = this.pixelBack[band];
                            float pixelFrame = this.pixelInput[band];
                            if (bg == Float.MAX_VALUE) {
                                segmented.data[indexSegmented] = this.unknownValue;
                                break block6;
                            }
                            float diff = bg - pixelFrame;
                            sumErrorSq += (double)(diff * diff);
                        }
                        segmented.data[indexSegmented] = sumErrorSq <= (double)thresholdSq ? (byte)0 : 1;
                    } else {
                        segmented.data[indexSegmented] = this.unknownValue;
                    }
                }
                ++x;
                ++indexFrame;
                ++indexSegmented;
            }
        }
    }
}

