/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.moving;

import boofcv.alg.background.moving.BackgroundMovingGmm;
import boofcv.struct.distort.Point2Transform2Model_F32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.InvertibleTransform;

public class BackgroundMovingGmm_SB<T extends ImageGray<T>, Motion extends InvertibleTransform<Motion>>
extends BackgroundMovingGmm<T, Motion> {
    public BackgroundMovingGmm_SB(float learningPeriod, float decayCoef, int maxGaussians, Point2Transform2Model_F32<Motion> transformImageType, ImageType<T> imageType) {
        super(learningPeriod, decayCoef, maxGaussians, transformImageType, imageType);
    }

    @Override
    protected void updateBackground(int x0, int y0, int x1, int y1, T frame) {
        this.common.inputWrapperG.wrap(frame);
        this.transform.setModel((Object)this.worldToCurrent);
        for (int y = y0; y < y1; ++y) {
            float[] modelRow = this.common.model.data[y];
            for (int x = x0; x < x1; ++x) {
                int indexModel = x * this.common.modelStride;
                this.transform.compute((float)x, (float)y, this.work);
                int xx = (int)(this.work.x + 0.5f);
                int yy = (int)(this.work.y + 0.5f);
                if (!(this.work.x >= 0.0f) || xx >= ((ImageGray)frame).width || !(this.work.y >= 0.0f) || yy >= ((ImageGray)frame).height) continue;
                float pixelValue = this.common.inputWrapperG.unsafe_getF(xx, yy);
                this.common.updateMixture(pixelValue, modelRow, indexModel);
            }
        }
    }

    @Override
    protected void _segment(Motion currentToWorld, T frame, GrayU8 segmented) {
        this.common.inputWrapperG.wrap(frame);
        this.transform.setModel(currentToWorld);
        this.common.unknownValue = this.unknownValue;
        for (int y = 0; y < ((ImageGray)frame).height; ++y) {
            int indexOut = segmented.startIndex + y * segmented.stride;
            int x = 0;
            while (x < ((ImageGray)frame).width) {
                this.transform.compute((float)x, (float)y, this.work);
                int xx = (int)(this.work.x + 0.5f);
                int yy = (int)(this.work.y + 0.5f);
                if (this.work.x >= 0.0f && xx < this.backgroundWidth && this.work.y >= 0.0f && yy < this.backgroundHeight) {
                    float pixelValue = this.common.inputWrapperG.unsafe_getF(x, y);
                    float[] modelRow = this.common.model.data[yy];
                    int indexModel = xx * this.common.modelStride;
                    segmented.data[indexOut] = (byte)this.common.checkBackground(pixelValue, modelRow, indexModel);
                } else {
                    segmented.data[indexOut] = this.unknownValue;
                }
                ++x;
                ++indexOut;
            }
        }
    }
}

