/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.descriptor;

import boofcv.abst.feature.describe.DescriptorInfo;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.feature.TupleDesc_F64;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class UtilFeature {
    public static <TD extends TupleDesc> FastQueue<TD> createQueue(final DescriptorInfo<TD> detDesc, int initialMax) {
        return new FastQueue<TD>(initialMax, detDesc.getDescriptionType(), true){

            protected TD createInstance() {
                return detDesc.createDescription();
            }
        };
    }

    public static FastQueue<TupleDesc_F64> createQueueF64(final int length) {
        return new FastQueue<TupleDesc_F64>(TupleDesc_F64.class, true){

            protected TupleDesc_F64 createInstance() {
                return new TupleDesc_F64(length);
            }
        };
    }

    public static TupleDesc_F64 combine(List<TupleDesc_F64> inputs, TupleDesc_F64 combined) {
        int N = 0;
        for (int i = 0; i < inputs.size(); ++i) {
            N += inputs.get(i).size();
        }
        if (combined == null) {
            combined = new TupleDesc_F64(N);
        } else if (N != combined.size()) {
            throw new RuntimeException("The combined feature needs to be " + N + "  not " + combined.size());
        }
        int start = 0;
        for (int i = 0; i < inputs.size(); ++i) {
            double[] v = inputs.get((int)i).value;
            System.arraycopy(v, 0, combined.value, start, v.length);
            start += v.length;
        }
        return combined;
    }

    public static void normalizeL2(TupleDesc_F64 desc) {
        int i;
        double norm = 0.0;
        for (i = 0; i < desc.size(); ++i) {
            double v = desc.value[i];
            norm += v * v;
        }
        if (norm == 0.0) {
            return;
        }
        norm = Math.sqrt(norm);
        i = 0;
        while (i < desc.size()) {
            int n = i++;
            desc.value[n] = desc.value[n] / norm;
        }
    }

    public static void normalizeSumOne(TupleDesc_F64 desc) {
        int i;
        double sum = 0.0;
        for (i = 0; i < desc.size(); ++i) {
            double v = desc.value[i];
            sum += v;
        }
        if (sum == 0.0) {
            return;
        }
        i = 0;
        while (i < desc.size()) {
            int n = i++;
            desc.value[n] = desc.value[n] / sum;
        }
    }
}

