/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.template;

import boofcv.alg.feature.detect.template.BaseTemplateIntensity;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;

public abstract class TemplateDiffSquared<T extends ImageBase<T>>
extends BaseTemplateIntensity<T> {
    @Override
    public boolean isBorderProcessed() {
        return false;
    }

    public static class U8
    extends TemplateDiffSquared<GrayU8> {
        @Override
        protected float evaluate(int tl_x, int tl_y) {
            float total = 0.0f;
            float div = 65025.0f;
            for (int y = 0; y < ((GrayU8)this.template).height; ++y) {
                int imageIndex = ((GrayU8)this.image).startIndex + (tl_y + y) * ((GrayU8)this.image).stride + tl_x;
                int templateIndex = ((GrayU8)this.template).startIndex + y * ((GrayU8)this.template).stride;
                int rowTotal = 0;
                for (int x = 0; x < ((GrayU8)this.template).width; ++x) {
                    int error = (((GrayU8)this.image).data[imageIndex++] & 0xFF) - (((GrayU8)this.template).data[templateIndex++] & 0xFF);
                    rowTotal += error * error;
                }
                total += (float)rowTotal / div;
            }
            return -total;
        }

        @Override
        protected float evaluateMask(int tl_x, int tl_y) {
            float total = 0.0f;
            float div = 1.6581375E7f;
            for (int y = 0; y < ((GrayU8)this.template).height; ++y) {
                int imageIndex = ((GrayU8)this.image).startIndex + (tl_y + y) * ((GrayU8)this.image).stride + tl_x;
                int templateIndex = ((GrayU8)this.template).startIndex + y * ((GrayU8)this.template).stride;
                int maskIndex = ((GrayU8)this.mask).startIndex + y * ((GrayU8)this.mask).stride;
                int rowTotal = 0;
                for (int x = 0; x < ((GrayU8)this.template).width; ++x) {
                    int m = ((GrayU8)this.mask).data[maskIndex++] & 0xFF;
                    int error = (((GrayU8)this.image).data[imageIndex++] & 0xFF) - (((GrayU8)this.template).data[templateIndex++] & 0xFF);
                    rowTotal += m * error * error;
                }
                total += (float)rowTotal / div;
            }
            return -total;
        }
    }

    public static class F32
    extends TemplateDiffSquared<GrayF32> {
        @Override
        protected float evaluate(int tl_x, int tl_y) {
            float total = 0.0f;
            for (int y = 0; y < ((GrayF32)this.template).height; ++y) {
                int imageIndex = ((GrayF32)this.image).startIndex + (tl_y + y) * ((GrayF32)this.image).stride + tl_x;
                int templateIndex = ((GrayF32)this.template).startIndex + y * ((GrayF32)this.template).stride;
                for (int x = 0; x < ((GrayF32)this.template).width; ++x) {
                    float error = ((GrayF32)this.image).data[imageIndex++] - ((GrayF32)this.template).data[templateIndex++];
                    total += error * error;
                }
            }
            return -total;
        }

        @Override
        protected float evaluateMask(int tl_x, int tl_y) {
            float total = 0.0f;
            for (int y = 0; y < ((GrayF32)this.template).height; ++y) {
                int imageIndex = ((GrayF32)this.image).startIndex + (tl_y + y) * ((GrayF32)this.image).stride + tl_x;
                int templateIndex = ((GrayF32)this.template).startIndex + y * ((GrayF32)this.template).stride;
                int maskIndex = ((GrayF32)this.mask).startIndex + y * ((GrayF32)this.mask).stride;
                for (int x = 0; x < ((GrayF32)this.template).width; ++x) {
                    float error = ((GrayF32)this.image).data[imageIndex++] - ((GrayF32)this.template).data[templateIndex++];
                    total += ((GrayF32)this.mask).data[maskIndex++] * error * error;
                }
            }
            return -total;
        }
    }
}

