/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation;

import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.alg.feature.describe.SurfDescribeOps;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.convolve.Kernel2D_F64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.sparse.GradientValue;
import boofcv.struct.sparse.SparseScaleGradient;

public abstract class OrientationIntegralBase<II extends ImageGray<II>, G extends GradientValue>
implements OrientationIntegral<II> {
    protected II ii;
    protected double scale = 1.0;
    protected int sampleRadius;
    protected int sampleWidth;
    protected Kernel2D_F64 weights;
    protected int kernelWidth;
    protected double period;
    protected double objectRadiusToScale;
    protected SparseScaleGradient<II, G> g;
    Class<II> integralType;

    public OrientationIntegralBase(double objectRadiusToScale, int sampleRadius, double period, int kernelWidth, double weightSigma, boolean assignDefaultRadius, Class<II> integralType) {
        this.objectRadiusToScale = objectRadiusToScale;
        this.sampleRadius = sampleRadius;
        this.period = period;
        this.kernelWidth = kernelWidth;
        this.sampleWidth = sampleRadius * 2 + 1;
        this.integralType = integralType;
        if (weightSigma != 0.0) {
            this.weights = (Kernel2D_F64)FactoryKernelGaussian.gaussian((int)2, (boolean)true, (int)64, (double)weightSigma, (int)sampleRadius);
        }
        this.g = SurfDescribeOps.createGradient(false, integralType);
        if (assignDefaultRadius) {
            this.setObjectRadius(1.0 / objectRadiusToScale);
        }
    }

    @Override
    public void setObjectRadius(double radius) {
        this.scale = radius * this.objectRadiusToScale;
        this.g.setWidth(this.scale * (double)this.kernelWidth);
    }

    @Override
    public void setImage(II integralImage) {
        this.ii = integralImage;
        this.g.setImage(this.ii);
    }

    @Override
    public Class<II> getImageType() {
        return this.integralType;
    }
}

