/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.ms;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.segmentation.ms.ClusterLabeledImage;
import boofcv.alg.segmentation.ms.MergeRegionMeanShift;
import boofcv.alg.segmentation.ms.MergeSmallRegions;
import boofcv.alg.segmentation.ms.SegmentMeanShiftSearch;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_I32;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;
import org.ddogleg.struct.Stoppable;

public class SegmentMeanShift<T extends ImageBase<T>>
implements Stoppable {
    SegmentMeanShiftSearch<T> search;
    MergeRegionMeanShift merge;
    ClusterLabeledImage segment;
    MergeSmallRegions<T> prune;
    volatile boolean stopRequested = false;

    public SegmentMeanShift(SegmentMeanShiftSearch<T> search, MergeRegionMeanShift merge, MergeSmallRegions<T> prune, ConnectRule connectRule) {
        this.search = search;
        this.merge = merge;
        this.prune = prune;
        this.segment = new ClusterLabeledImage(connectRule);
    }

    public void process(T image, GrayS32 output) {
        InputSanityCheck.checkSameShape(image, (ImageBase)output);
        this.stopRequested = false;
        this.search.process(image);
        if (this.stopRequested) {
            return;
        }
        FastQueue<float[]> regionColor = this.search.getModeColor();
        GrayS32 pixelToRegion = this.search.getPixelToRegion();
        GrowQueue_I32 regionPixelCount = this.search.getRegionMemberCount();
        FastQueue<Point2D_I32> modeLocation = this.search.getModeLocation();
        this.merge.process(pixelToRegion, regionPixelCount, regionColor, modeLocation);
        if (this.stopRequested) {
            return;
        }
        this.segment.process(pixelToRegion, output, regionPixelCount);
        if (this.stopRequested) {
            return;
        }
        if (this.prune != null) {
            this.prune.process(image, output, regionPixelCount, regionColor);
        }
    }

    public int getNumberOfRegions() {
        return this.search.getRegionMemberCount().size;
    }

    public FastQueue<float[]> getRegionColor() {
        return this.search.getModeColor();
    }

    public GrowQueue_I32 getRegionSize() {
        return this.search.getRegionMemberCount();
    }

    public ImageType<T> getImageType() {
        return this.search.getImageType();
    }

    public void requestStop() {
        this.stopRequested = true;
        this.search.requestStop();
        this.merge.requestStop();
    }

    public boolean isStopRequested() {
        return this.stopRequested;
    }
}

