/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.edge;

import boofcv.alg.interpolate.ImageLineIntegral;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.core.image.FactoryGImageGray;
import boofcv.core.image.GImageGray;
import boofcv.core.image.GImageGrayDistorted;
import boofcv.core.image.border.BorderType;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.distort.PixelTransform2_F32;
import boofcv.struct.image.ImageGray;

public class BaseIntegralEdge<T extends ImageGray<T>> {
    Class<T> imageType;
    protected ImageLineIntegral integral;
    protected GImageGray integralImage;

    public BaseIntegralEdge(Class<T> imageType) {
        this.imageType = imageType;
        this.integral = new ImageLineIntegral();
        this.integralImage = FactoryGImageGray.create(imageType);
    }

    public void setTransform(PixelTransform2_F32 undistToDist) {
        if (undistToDist != null) {
            InterpolatePixelS interpolate = FactoryInterpolation.bilinearPixelS(this.imageType, (BorderType)BorderType.EXTENDED);
            this.integralImage = new GImageGrayDistorted(undistToDist, interpolate);
        } else {
            this.integralImage = FactoryGImageGray.create(this.imageType);
        }
    }

    public void setImage(T image) {
        this.integralImage.wrap(image);
        this.integral.setImage(this.integralImage);
    }

    public Class<T> getInputType() {
        return this.imageType;
    }
}

