/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.edge;

import boofcv.alg.shapes.edge.ScoreLineSegmentEdge;
import boofcv.struct.distort.PixelTransform2_F32;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;

public class EdgeIntensityPolygon<T extends ImageGray<T>> {
    private double cornerOffset;
    private double tangentDistance;
    private Point2D_F64 offsetA = new Point2D_F64();
    private Point2D_F64 offsetB = new Point2D_F64();
    private double averageInside;
    private double averageOutside;
    ScoreLineSegmentEdge<T> scorer;

    public EdgeIntensityPolygon(double cornerOffset, double tangentDistance, int numSamples, Class<T> imageType) {
        this.cornerOffset = cornerOffset;
        this.tangentDistance = tangentDistance;
        this.scorer = new ScoreLineSegmentEdge<T>(numSamples, imageType);
    }

    public void setTransform(PixelTransform2_F32 undistToDist) {
        this.scorer.setTransform(undistToDist);
    }

    public void setImage(T image) {
        this.scorer.setImage(image);
    }

    public boolean computeEdge(Polygon2D_F64 polygon, boolean ccw) {
        this.averageInside = 0.0;
        this.averageOutside = 0.0;
        double tangentSign = ccw ? 1.0 : -1.0;
        int totalSides = 0;
        int i = polygon.size() - 1;
        int j = 0;
        while (j < polygon.size()) {
            Point2D_F64 a = polygon.get(i);
            Point2D_F64 b = polygon.get(j);
            double dx = b.x - a.x;
            double dy = b.y - a.y;
            double t = Math.sqrt(dx * dx + dy * dy);
            dx /= t;
            dy /= t;
            if (t < 3.0 * this.cornerOffset) {
                this.offsetA.set(a);
                this.offsetB.set(b);
            } else {
                this.offsetA.x = a.x + this.cornerOffset * dx;
                this.offsetA.y = a.y + this.cornerOffset * dy;
                this.offsetB.x = b.x - this.cornerOffset * dx;
                this.offsetB.y = b.y - this.cornerOffset * dy;
            }
            double tanX = -dy * this.tangentDistance * tangentSign;
            double tanY = dx * this.tangentDistance * tangentSign;
            this.scorer.computeAverageDerivative(this.offsetA, this.offsetB, tanX, tanY);
            if (this.scorer.getSamplesInside() > 0) {
                ++totalSides;
                this.averageInside += this.scorer.getAverageUp() / this.tangentDistance;
                this.averageOutside += this.scorer.getAverageDown() / this.tangentDistance;
            }
            i = j++;
        }
        if (totalSides > 0) {
            this.averageInside /= (double)totalSides;
            this.averageOutside /= (double)totalSides;
        } else {
            this.averageOutside = 0.0;
            this.averageInside = 0.0;
            return false;
        }
        return true;
    }

    public boolean checkIntensity(boolean insideDark, double threshold) {
        if (insideDark) {
            return this.averageOutside - this.averageInside >= threshold;
        }
        return this.averageInside - this.averageOutside >= threshold;
    }

    public double getCornerOffset() {
        return this.cornerOffset;
    }

    public void setCornerOffset(double cornerOffset) {
        this.cornerOffset = cornerOffset;
    }

    public double getTangentDistance() {
        return this.tangentDistance;
    }

    public void setTangentDistance(double tangentDistance) {
        this.tangentDistance = tangentDistance;
    }

    public double getAverageInside() {
        return this.averageInside;
    }

    public double getAverageOutside() {
        return this.averageOutside;
    }
}

