/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.intensity;

import boofcv.alg.feature.detect.intensity.FastCornerDetector;
import boofcv.alg.feature.detect.intensity.HarrisCornerIntensity;
import boofcv.alg.feature.detect.intensity.ShiTomasiCornerIntensity;
import boofcv.alg.feature.detect.intensity.impl.ImplFastCorner10_F32;
import boofcv.alg.feature.detect.intensity.impl.ImplFastCorner10_U8;
import boofcv.alg.feature.detect.intensity.impl.ImplFastCorner11_F32;
import boofcv.alg.feature.detect.intensity.impl.ImplFastCorner11_U8;
import boofcv.alg.feature.detect.intensity.impl.ImplFastCorner12_F32;
import boofcv.alg.feature.detect.intensity.impl.ImplFastCorner12_U8;
import boofcv.alg.feature.detect.intensity.impl.ImplFastCorner9_F32;
import boofcv.alg.feature.detect.intensity.impl.ImplFastCorner9_U8;
import boofcv.alg.feature.detect.intensity.impl.ImplHarrisCornerWeighted_F32;
import boofcv.alg.feature.detect.intensity.impl.ImplHarrisCornerWeighted_S16;
import boofcv.alg.feature.detect.intensity.impl.ImplHarrisCorner_F32;
import boofcv.alg.feature.detect.intensity.impl.ImplHarrisCorner_S16;
import boofcv.alg.feature.detect.intensity.impl.ImplShiTomasiCornerWeighted_F32;
import boofcv.alg.feature.detect.intensity.impl.ImplShiTomasiCornerWeighted_S16;
import boofcv.alg.feature.detect.intensity.impl.ImplShiTomasiCorner_F32;
import boofcv.alg.feature.detect.intensity.impl.ImplShiTomasiCorner_S16;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public class FactoryIntensityPointAlg {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends ImageGray<T>> FastCornerDetector<T> fast(int pixelTol, int minCont, Class<T> imageType) {
        void var3_11;
        if (imageType == GrayF32.class) {
            if (minCont == 9) {
                ImplFastCorner9_F32 implFastCorner9_F32 = new ImplFastCorner9_F32(pixelTol);
                return new FastCornerDetector(var3_11);
            } else if (minCont == 10) {
                ImplFastCorner10_F32 implFastCorner10_F32 = new ImplFastCorner10_F32(pixelTol);
                return new FastCornerDetector(var3_11);
            } else if (minCont == 11) {
                ImplFastCorner11_F32 implFastCorner11_F32 = new ImplFastCorner11_F32(pixelTol);
                return new FastCornerDetector(var3_11);
            } else {
                if (minCont != 12) throw new IllegalArgumentException("Specified minCont is not supported");
                ImplFastCorner12_F32 implFastCorner12_F32 = new ImplFastCorner12_F32(pixelTol);
            }
            return new FastCornerDetector(var3_11);
        } else {
            if (imageType != GrayU8.class) throw new IllegalArgumentException("Unknown image type");
            if (minCont == 9) {
                ImplFastCorner9_U8 implFastCorner9_U8 = new ImplFastCorner9_U8(pixelTol);
                return new FastCornerDetector(var3_11);
            } else if (minCont == 10) {
                ImplFastCorner10_U8 implFastCorner10_U8 = new ImplFastCorner10_U8(pixelTol);
                return new FastCornerDetector(var3_11);
            } else if (minCont == 11) {
                ImplFastCorner11_U8 implFastCorner11_U8 = new ImplFastCorner11_U8(pixelTol);
                return new FastCornerDetector(var3_11);
            } else {
                if (minCont != 12) throw new IllegalArgumentException("Specified minCont is not supported");
                ImplFastCorner12_U8 implFastCorner12_U8 = new ImplFastCorner12_U8(pixelTol);
            }
        }
        return new FastCornerDetector(var3_11);
    }

    public static <D extends ImageGray<D>> HarrisCornerIntensity<D> harris(int windowRadius, float kappa, boolean weighted, Class<D> derivType) {
        if (derivType == GrayF32.class) {
            if (weighted) {
                return new ImplHarrisCornerWeighted_F32(windowRadius, kappa);
            }
            return new ImplHarrisCorner_F32(windowRadius, kappa);
        }
        if (derivType == GrayS16.class) {
            if (weighted) {
                return new ImplHarrisCornerWeighted_S16(windowRadius, kappa);
            }
            return new ImplHarrisCorner_S16(windowRadius, kappa);
        }
        throw new IllegalArgumentException("Unknown image type " + derivType);
    }

    public static <D extends ImageGray<D>> ShiTomasiCornerIntensity<D> shiTomasi(int windowRadius, boolean weighted, Class<D> derivType) {
        if (derivType == GrayF32.class) {
            if (weighted) {
                return new ImplShiTomasiCornerWeighted_F32(windowRadius);
            }
            return new ImplShiTomasiCorner_F32(windowRadius);
        }
        if (derivType == GrayS16.class) {
            if (weighted) {
                return new ImplShiTomasiCornerWeighted_S16(windowRadius);
            }
            return new ImplShiTomasiCorner_S16(windowRadius);
        }
        throw new IllegalArgumentException("Unknown image type " + derivType);
    }
}

