/*
 * Copyright (c) 2011-2018, Peter Abeles. All Rights Reserved.
 *
 * This file is part of BoofCV (http://boofcv.org).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package boofcv.alg.geo.robust;

import boofcv.abst.geo.Estimate1ofTrifocalTensor;
import boofcv.struct.geo.AssociatedTriple;
import boofcv.struct.geo.TrifocalTensor;
import org.ddogleg.fitting.modelset.ModelGenerator;

import java.util.List;

/**
 * Wrapper around {@link Estimate1ofTrifocalTensor} for {@link ModelGenerator}
 *
 * @author Peter Abeles
 */
public class GenerateTrifocalTensor implements
		ModelGenerator<TrifocalTensor, AssociatedTriple>
{
	Estimate1ofTrifocalTensor trifocal;

	public GenerateTrifocalTensor(Estimate1ofTrifocalTensor trifocal) {
		this.trifocal = trifocal;
	}

	@Override
	public boolean generate(List<AssociatedTriple> dataSet, TrifocalTensor output) {
		return trifocal.process(dataSet,output);
	}

	@Override
	public int getMinimumPoints() {
		return trifocal.getMinimumPoints();
	}
}
