/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Map;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.avcodec;
import org.bytedeco.javacpp.avformat;
import org.bytedeco.javacpp.avutil;
import org.bytedeco.javacpp.swresample;
import org.bytedeco.javacpp.swscale;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameRecorder;

public class FFmpegFrameRecorder
extends FrameRecorder {
    private static FrameRecorder.Exception loadingException = null;
    private String filename;
    private avutil.AVFrame picture;
    private avutil.AVFrame tmp_picture;
    private BytePointer picture_buf;
    private BytePointer video_outbuf;
    private int video_outbuf_size;
    private avutil.AVFrame frame;
    private Pointer[] samples_in;
    private BytePointer[] samples_out;
    private PointerPointer samples_in_ptr;
    private PointerPointer samples_out_ptr;
    private BytePointer audio_outbuf;
    private int audio_outbuf_size;
    private int audio_input_frame_size;
    private avformat.AVOutputFormat oformat;
    private avformat.AVFormatContext oc;
    private avcodec.AVCodec video_codec;
    private avcodec.AVCodec audio_codec;
    private avcodec.AVCodecContext video_c;
    private avcodec.AVCodecContext audio_c;
    private avformat.AVStream video_st;
    private avformat.AVStream audio_st;
    private swscale.SwsContext img_convert_ctx;
    private swresample.SwrContext samples_convert_ctx;
    private int samples_channels;
    private int samples_format;
    private int samples_rate;
    private avcodec.AVPacket video_pkt;
    private avcodec.AVPacket audio_pkt;
    private int[] got_video_packet;
    private int[] got_audio_packet;

    public static FFmpegFrameRecorder createDefault(File f, int w, int h) throws FrameRecorder.Exception {
        return new FFmpegFrameRecorder(f, w, h);
    }

    public static FFmpegFrameRecorder createDefault(String f, int w, int h) throws FrameRecorder.Exception {
        return new FFmpegFrameRecorder(f, w, h);
    }

    public static void tryLoad() throws FrameRecorder.Exception {
        if (loadingException != null) {
            throw loadingException;
        }
        try {
            Loader.load(avutil.class);
            Loader.load(swresample.class);
            Loader.load(avcodec.class);
            Loader.load(avformat.class);
            Loader.load(swscale.class);
            avformat.av_register_all();
            avformat.avformat_network_init();
        }
        catch (Throwable t) {
            if (t instanceof FrameRecorder.Exception) {
                loadingException = (FrameRecorder.Exception)t;
                throw loadingException;
            }
            loadingException = new FrameRecorder.Exception("Failed to load " + FFmpegFrameRecorder.class, t);
            throw loadingException;
        }
    }

    public FFmpegFrameRecorder(File file, int audioChannels) {
        this(file, 0, 0, audioChannels);
    }

    public FFmpegFrameRecorder(String filename, int audioChannels) {
        this(filename, 0, 0, audioChannels);
    }

    public FFmpegFrameRecorder(File file, int imageWidth, int imageHeight) {
        this(file, imageWidth, imageHeight, 0);
    }

    public FFmpegFrameRecorder(String filename, int imageWidth, int imageHeight) {
        this(filename, imageWidth, imageHeight, 0);
    }

    public FFmpegFrameRecorder(File file, int imageWidth, int imageHeight, int audioChannels) {
        this(file.getAbsolutePath(), imageWidth, imageHeight, audioChannels);
    }

    public FFmpegFrameRecorder(String filename, int imageWidth, int imageHeight, int audioChannels) {
        this.filename = filename;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.audioChannels = audioChannels;
        this.pixelFormat = -1;
        this.videoCodec = 0;
        this.videoBitrate = 400000;
        this.frameRate = 30.0;
        this.sampleFormat = -1;
        this.audioCodec = 0;
        this.audioBitrate = 64000;
        this.sampleRate = 44100;
        this.interleaved = true;
        this.video_pkt = new avcodec.AVPacket();
        this.audio_pkt = new avcodec.AVPacket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() throws FrameRecorder.Exception {
        Class<avcodec> clazz = avcodec.class;
        synchronized (avcodec.class) {
            this.releaseUnsafe();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void releaseUnsafe() throws FrameRecorder.Exception {
        if (this.video_c != null) {
            avcodec.avcodec_close((avcodec.AVCodecContext)this.video_c);
            this.video_c = null;
        }
        if (this.audio_c != null) {
            avcodec.avcodec_close((avcodec.AVCodecContext)this.audio_c);
            this.audio_c = null;
        }
        if (this.picture_buf != null) {
            avutil.av_free((Pointer)this.picture_buf);
            this.picture_buf = null;
        }
        if (this.picture != null) {
            avutil.av_frame_free((avutil.AVFrame)this.picture);
            this.picture = null;
        }
        if (this.tmp_picture != null) {
            avutil.av_frame_free((avutil.AVFrame)this.tmp_picture);
            this.tmp_picture = null;
        }
        if (this.video_outbuf != null) {
            avutil.av_free((Pointer)this.video_outbuf);
            this.video_outbuf = null;
        }
        if (this.frame != null) {
            avutil.av_frame_free((avutil.AVFrame)this.frame);
            this.frame = null;
        }
        if (this.samples_out != null) {
            for (int i = 0; i < this.samples_out.length; ++i) {
                avutil.av_free((Pointer)this.samples_out[i].position(0));
            }
            this.samples_out = null;
        }
        if (this.audio_outbuf != null) {
            avutil.av_free((Pointer)this.audio_outbuf);
            this.audio_outbuf = null;
        }
        this.video_st = null;
        this.audio_st = null;
        if (this.oc != null && !this.oc.isNull()) {
            if ((this.oformat.flags() & 1) == 0) {
                avformat.avio_close((avformat.AVIOContext)this.oc.pb());
            }
            int nb_streams = this.oc.nb_streams();
            for (int i = 0; i < nb_streams; ++i) {
                avutil.av_free((Pointer)this.oc.streams(i).codec());
                avutil.av_free((Pointer)this.oc.streams(i));
            }
            avutil.av_free((Pointer)this.oc);
            this.oc = null;
        }
        if (this.img_convert_ctx != null) {
            swscale.sws_freeContext((swscale.SwsContext)this.img_convert_ctx);
            this.img_convert_ctx = null;
        }
        if (this.samples_convert_ctx != null) {
            swresample.swr_free((swresample.SwrContext)this.samples_convert_ctx);
            this.samples_convert_ctx = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    @Override
    public int getFrameNumber() {
        return this.picture == null ? super.getFrameNumber() : (int)this.picture.pts();
    }

    @Override
    public void setFrameNumber(int frameNumber) {
        if (this.picture == null) {
            super.setFrameNumber(frameNumber);
        } else {
            this.picture.pts((long)frameNumber);
        }
    }

    @Override
    public long getTimestamp() {
        return Math.round((double)((long)this.getFrameNumber() * 1000000L) / this.getFrameRate());
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.setFrameNumber((int)Math.round((double)timestamp * this.getFrameRate() / 1000000.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws FrameRecorder.Exception {
        Class<avcodec> clazz = avcodec.class;
        synchronized (avcodec.class) {
            this.startUnsafe();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void startUnsafe() throws FrameRecorder.Exception {
        int ret;
        this.picture = null;
        this.tmp_picture = null;
        this.picture_buf = null;
        this.frame = null;
        this.video_outbuf = null;
        this.audio_outbuf = null;
        this.oc = null;
        this.video_c = null;
        this.audio_c = null;
        this.video_st = null;
        this.audio_st = null;
        this.got_video_packet = new int[1];
        this.got_audio_packet = new int[1];
        String format_name = this.format == null || this.format.length() == 0 ? null : this.format;
        this.oformat = avformat.av_guess_format((String)format_name, (String)this.filename, null);
        if (this.oformat == null) {
            int proto = this.filename.indexOf("://");
            if (proto > 0) {
                format_name = this.filename.substring(0, proto);
            }
            if ((this.oformat = avformat.av_guess_format((String)format_name, (String)this.filename, null)) == null) {
                throw new FrameRecorder.Exception("av_guess_format() error: Could not guess output format for \"" + this.filename + "\" and " + this.format + " format.");
            }
        }
        format_name = this.oformat.name().getString();
        this.oc = avformat.avformat_alloc_context();
        if (this.oc == null) {
            throw new FrameRecorder.Exception("avformat_alloc_context() error: Could not allocate format context");
        }
        this.oc.oformat(this.oformat);
        this.oc.filename().putString(this.filename);
        if (this.imageWidth > 0 && this.imageHeight > 0) {
            if (this.videoCodec != 0) {
                this.oformat.video_codec(this.videoCodec);
            } else if ("flv".equals(format_name)) {
                this.oformat.video_codec(22);
            } else if ("mp4".equals(format_name)) {
                this.oformat.video_codec(13);
            } else if ("3gp".equals(format_name)) {
                this.oformat.video_codec(5);
            } else if ("avi".equals(format_name)) {
                this.oformat.video_codec(26);
            }
            this.video_codec = avcodec.avcodec_find_encoder_by_name((String)this.videoCodecName);
            if (this.video_codec == null && (this.video_codec = avcodec.avcodec_find_encoder((int)this.oformat.video_codec())) == null) {
                this.release();
                throw new FrameRecorder.Exception("avcodec_find_encoder() error: Video codec not found.");
            }
            avutil.AVRational frame_rate = avutil.av_d2q((double)this.frameRate, (int)1001000);
            avutil.AVRational supported_framerates = this.video_codec.supported_framerates();
            if (supported_framerates != null) {
                int n = avutil.av_find_nearest_q_idx((avutil.AVRational)frame_rate, (avutil.AVRational)supported_framerates);
                frame_rate = supported_framerates.position(n);
            }
            if ((this.video_st = avformat.avformat_new_stream((avformat.AVFormatContext)this.oc, (avcodec.AVCodec)this.video_codec)) == null) {
                this.release();
                throw new FrameRecorder.Exception("avformat_new_stream() error: Could not allocate video stream.");
            }
            this.video_c = this.video_st.codec();
            this.video_c.codec_id(this.oformat.video_codec());
            this.video_c.codec_type(0);
            this.video_c.bit_rate(this.videoBitrate);
            this.video_c.width((this.imageWidth + 15) / 16 * 16);
            this.video_c.height(this.imageHeight);
            this.video_c.time_base(avutil.av_inv_q((avutil.AVRational)frame_rate));
            this.video_st.time_base(avutil.av_inv_q((avutil.AVRational)frame_rate));
            if (this.gopSize >= 0) {
                this.video_c.gop_size(this.gopSize);
            }
            if (this.videoQuality >= 0.0) {
                this.video_c.flags(this.video_c.flags() | 2);
                this.video_c.global_quality((int)Math.round(118.0 * this.videoQuality));
            }
            if (this.pixelFormat != -1) {
                this.video_c.pix_fmt(this.pixelFormat);
            } else if (this.video_c.codec_id() == 14 || this.video_c.codec_id() == 62 || this.video_c.codec_id() == 26 || this.video_c.codec_id() == 34) {
                this.video_c.pix_fmt(avutil.AV_PIX_FMT_RGB32);
            } else {
                this.video_c.pix_fmt(0);
            }
            if (this.video_c.codec_id() == 2) {
                this.video_c.max_b_frames(2);
            } else if (this.video_c.codec_id() == 1) {
                this.video_c.mb_decision(2);
            } else if (this.video_c.codec_id() == 5) {
                if (this.imageWidth <= 128 && this.imageHeight <= 96) {
                    this.video_c.width(128).height(96);
                } else if (this.imageWidth <= 176 && this.imageHeight <= 144) {
                    this.video_c.width(176).height(144);
                } else if (this.imageWidth <= 352 && this.imageHeight <= 288) {
                    this.video_c.width(352).height(288);
                } else if (this.imageWidth <= 704 && this.imageHeight <= 576) {
                    this.video_c.width(704).height(576);
                } else {
                    this.video_c.width(1408).height(1152);
                }
            } else if (this.video_c.codec_id() == 28) {
                this.video_c.profile(578);
            }
            if ((this.oformat.flags() & 0x40) != 0) {
                this.video_c.flags(this.video_c.flags() | 0x400000);
            }
            if ((this.video_codec.capabilities() & 0x200) != 0) {
                this.video_c.strict_std_compliance(-2);
            }
        }
        if (this.audioChannels > 0 && this.audioBitrate > 0 && this.sampleRate > 0) {
            if (this.audioCodec != 0) {
                this.oformat.audio_codec(this.audioCodec);
            } else if ("flv".equals(format_name) || "mp4".equals(format_name) || "3gp".equals(format_name)) {
                this.oformat.audio_codec(86018);
            } else if ("avi".equals(format_name)) {
                this.oformat.audio_codec(65536);
            }
            this.audio_codec = avcodec.avcodec_find_encoder_by_name((String)this.audioCodecName);
            if (this.audio_codec == null && (this.audio_codec = avcodec.avcodec_find_encoder((int)this.oformat.audio_codec())) == null) {
                this.release();
                throw new FrameRecorder.Exception("avcodec_find_encoder() error: Audio codec not found.");
            }
            this.audio_st = avformat.avformat_new_stream((avformat.AVFormatContext)this.oc, (avcodec.AVCodec)this.audio_codec);
            if (this.audio_st == null) {
                this.release();
                throw new FrameRecorder.Exception("avformat_new_stream() error: Could not allocate audio stream.");
            }
            this.audio_c = this.audio_st.codec();
            this.audio_c.codec_id(this.oformat.audio_codec());
            this.audio_c.codec_type(1);
            this.audio_c.bit_rate(this.audioBitrate);
            this.audio_c.sample_rate(this.sampleRate);
            this.audio_c.channels(this.audioChannels);
            this.audio_c.channel_layout(avutil.av_get_default_channel_layout((int)this.audioChannels));
            if (this.sampleFormat != -1) {
                this.audio_c.sample_fmt(this.sampleFormat);
            } else if ((this.audio_codec.capabilities() & 0x200) != 0 && (this.audio_c.codec_id() == 86021 || this.audio_c.codec_id() == 86018)) {
                this.audio_c.sample_fmt(8);
            } else {
                this.audio_c.sample_fmt(1);
            }
            this.audio_c.time_base().num(1).den(this.sampleRate);
            this.audio_st.time_base().num(1).den(this.sampleRate);
            switch (this.audio_c.sample_fmt()) {
                case 0: 
                case 5: {
                    this.audio_c.bits_per_raw_sample(8);
                    break;
                }
                case 1: 
                case 6: {
                    this.audio_c.bits_per_raw_sample(16);
                    break;
                }
                case 2: 
                case 7: {
                    this.audio_c.bits_per_raw_sample(32);
                    break;
                }
                case 3: 
                case 8: {
                    this.audio_c.bits_per_raw_sample(32);
                    break;
                }
                case 4: 
                case 9: {
                    this.audio_c.bits_per_raw_sample(64);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (this.audioQuality >= 0.0) {
                this.audio_c.flags(this.audio_c.flags() | 2);
                this.audio_c.global_quality((int)Math.round(118.0 * this.audioQuality));
            }
            if ((this.oformat.flags() & 0x40) != 0) {
                this.audio_c.flags(this.audio_c.flags() | 0x400000);
            }
            if ((this.audio_codec.capabilities() & 0x200) != 0) {
                this.audio_c.strict_std_compliance(-2);
            }
        }
        avformat.av_dump_format((avformat.AVFormatContext)this.oc, (int)0, (String)this.filename, (int)1);
        if (this.video_st != null) {
            avutil.AVDictionary options = new avutil.AVDictionary(null);
            if (this.videoQuality >= 0.0) {
                avutil.av_dict_set((avutil.AVDictionary)options, (String)"crf", (String)("" + this.videoQuality), (int)0);
            }
            for (Map.Entry entry : this.videoOptions.entrySet()) {
                avutil.av_dict_set((avutil.AVDictionary)options, (String)((String)entry.getKey()), (String)((String)entry.getValue()), (int)0);
            }
            ret = avcodec.avcodec_open2((avcodec.AVCodecContext)this.video_c, (avcodec.AVCodec)this.video_codec, (avutil.AVDictionary)options);
            if (ret < 0) {
                this.release();
                throw new FrameRecorder.Exception("avcodec_open2() error " + ret + ": Could not open video codec.");
            }
            avutil.av_dict_free((avutil.AVDictionary)options);
            this.video_outbuf = null;
            if ((this.oformat.flags() & 0x20) == 0) {
                this.video_outbuf_size = Math.max(262144, 8 * this.video_c.width() * this.video_c.height());
                this.video_outbuf = new BytePointer(avutil.av_malloc((long)this.video_outbuf_size));
            }
            if ((this.picture = avutil.av_frame_alloc()) == null) {
                this.release();
                throw new FrameRecorder.Exception("av_frame_alloc() error: Could not allocate picture.");
            }
            this.picture.pts(0L);
            int size = avcodec.avpicture_get_size((int)this.video_c.pix_fmt(), (int)this.video_c.width(), (int)this.video_c.height());
            this.picture_buf = new BytePointer(avutil.av_malloc((long)size));
            if (this.picture_buf.isNull()) {
                this.release();
                throw new FrameRecorder.Exception("av_malloc() error: Could not allocate picture buffer.");
            }
            this.tmp_picture = avutil.av_frame_alloc();
            if (this.tmp_picture == null) {
                this.release();
                throw new FrameRecorder.Exception("av_frame_alloc() error: Could not allocate temporary picture.");
            }
        }
        if (this.audio_st != null) {
            avutil.AVDictionary options = new avutil.AVDictionary(null);
            if (this.audioQuality >= 0.0) {
                avutil.av_dict_set((avutil.AVDictionary)options, (String)"crf", (String)("" + this.audioQuality), (int)0);
            }
            for (Map.Entry entry : this.audioOptions.entrySet()) {
                avutil.av_dict_set((avutil.AVDictionary)options, (String)((String)entry.getKey()), (String)((String)entry.getValue()), (int)0);
            }
            ret = avcodec.avcodec_open2((avcodec.AVCodecContext)this.audio_c, (avcodec.AVCodec)this.audio_codec, (avutil.AVDictionary)options);
            if (ret < 0) {
                this.release();
                throw new FrameRecorder.Exception("avcodec_open2() error " + ret + ": Could not open audio codec.");
            }
            avutil.av_dict_free((avutil.AVDictionary)options);
            this.audio_outbuf_size = 262144;
            this.audio_outbuf = new BytePointer(avutil.av_malloc((long)this.audio_outbuf_size));
            if (this.audio_c.frame_size() <= 1) {
                this.audio_outbuf_size = 16384;
                this.audio_input_frame_size = this.audio_outbuf_size / this.audio_c.channels();
                switch (this.audio_c.codec_id()) {
                    case 65536: 
                    case 65537: 
                    case 65538: 
                    case 65539: {
                        this.audio_input_frame_size >>= 1;
                        break;
                    }
                }
            } else {
                this.audio_input_frame_size = this.audio_c.frame_size();
            }
            int planes = avutil.av_sample_fmt_is_planar((int)this.audio_c.sample_fmt()) != 0 ? this.audio_c.channels() : 1;
            int n = avutil.av_samples_get_buffer_size((IntPointer)null, (int)this.audio_c.channels(), (int)this.audio_input_frame_size, (int)this.audio_c.sample_fmt(), (int)1) / planes;
            this.samples_out = new BytePointer[planes];
            for (int i = 0; i < this.samples_out.length; ++i) {
                this.samples_out[i] = new BytePointer(avutil.av_malloc((long)n)).capacity(n);
            }
            this.samples_in = new Pointer[8];
            this.samples_in_ptr = new PointerPointer(8);
            this.samples_out_ptr = new PointerPointer(8);
            this.frame = avutil.av_frame_alloc();
            if (this.frame == null) {
                this.release();
                throw new FrameRecorder.Exception("av_frame_alloc() error: Could not allocate audio frame.");
            }
            this.frame.pts(0L);
        }
        if ((this.oformat.flags() & 1) == 0) {
            avformat.AVIOContext pb = new avformat.AVIOContext(null);
            ret = avformat.avio_open((avformat.AVIOContext)pb, (String)this.filename, (int)2);
            if (ret < 0) {
                this.release();
                throw new FrameRecorder.Exception("avio_open error() error " + ret + ": Could not open '" + this.filename + "'");
            }
            this.oc.pb(pb);
        }
        avformat.avformat_write_header((avformat.AVFormatContext)this.oc, (PointerPointer)null);
    }

    @Override
    public void stop() throws FrameRecorder.Exception {
        if (this.oc != null) {
            try {
                while (this.video_st != null && this.recordImage(0, 0, 0, 0, 0, -1, null)) {
                }
                while (this.audio_st != null && this.recordSamples(0, 0, (Buffer[])null)) {
                }
                if (this.interleaved && this.video_st != null && this.audio_st != null) {
                    avformat.av_interleaved_write_frame((avformat.AVFormatContext)this.oc, null);
                } else {
                    avformat.av_write_frame((avformat.AVFormatContext)this.oc, null);
                }
                avformat.av_write_trailer((avformat.AVFormatContext)this.oc);
            }
            finally {
                this.release();
            }
        }
    }

    @Override
    public void record(Frame frame) throws FrameRecorder.Exception {
        if (frame == null || frame.image == null && frame.samples == null) {
            this.recordImage(0, 0, 0, 0, 0, -1, null);
        } else {
            if (frame.image != null) {
                frame.keyFrame = this.recordImage(frame.imageWidth, frame.imageHeight, frame.imageDepth, frame.imageChannels, frame.imageStride, -1, frame.image);
            }
            if (frame.samples != null) {
                frame.keyFrame = this.recordSamples(frame.sampleRate, frame.audioChannels, frame.samples);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recordImage(int width, int height, int depth, int channels, int stride, int pixelFormat, Buffer ... image) throws FrameRecorder.Exception {
        int ret;
        if (this.video_st == null) {
            throw new FrameRecorder.Exception("No video output stream (Is imageWidth > 0 && imageHeight > 0 and has start() been called?)");
        }
        if (image != null && image.length != 0) {
            BytePointer data;
            int step = stride * Math.abs(depth) / 8;
            BytePointer bytePointer = data = image[0] instanceof ByteBuffer ? new BytePointer((ByteBuffer)image[0].position(0)) : new BytePointer(new Pointer(image[0].position(0)));
            if (pixelFormat == -1) {
                if ((depth == 8 || depth == -8) && channels == 3) {
                    pixelFormat = 3;
                } else if ((depth == 8 || depth == -8) && channels == 1) {
                    pixelFormat = 8;
                } else if ((depth == 16 || depth == -16) && channels == 1) {
                    pixelFormat = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? 31 : 32;
                } else if ((depth == 8 || depth == -8) && channels == 4) {
                    pixelFormat = 28;
                } else if ((depth == 8 || depth == -8) && channels == 2) {
                    pixelFormat = 26;
                    step = width;
                } else {
                    throw new FrameRecorder.Exception("Could not guess pixel format of image: depth=" + depth + ", channels=" + channels);
                }
            }
            if (this.video_c.pix_fmt() != pixelFormat || this.video_c.width() != width || this.video_c.height() != height) {
                this.img_convert_ctx = swscale.sws_getCachedContext((swscale.SwsContext)this.img_convert_ctx, (int)width, (int)height, (int)pixelFormat, (int)this.video_c.width(), (int)this.video_c.height(), (int)this.video_c.pix_fmt(), (int)2, null, null, (DoublePointer)null);
                if (this.img_convert_ctx == null) {
                    throw new FrameRecorder.Exception("sws_getCachedContext() error: Cannot initialize the conversion context.");
                }
                avcodec.avpicture_fill((avcodec.AVPicture)new avcodec.AVPicture((Pointer)this.tmp_picture), (BytePointer)data, (int)pixelFormat, (int)width, (int)height);
                avcodec.avpicture_fill((avcodec.AVPicture)new avcodec.AVPicture((Pointer)this.picture), (BytePointer)this.picture_buf, (int)this.video_c.pix_fmt(), (int)this.video_c.width(), (int)this.video_c.height());
                this.tmp_picture.linesize(0, step);
                this.tmp_picture.format(pixelFormat);
                this.tmp_picture.width(width);
                this.tmp_picture.height(height);
                this.picture.format(this.video_c.pix_fmt());
                this.picture.width(this.video_c.width());
                this.picture.height(this.video_c.height());
                swscale.sws_scale((swscale.SwsContext)this.img_convert_ctx, (PointerPointer)new PointerPointer((Pointer)this.tmp_picture), (IntPointer)this.tmp_picture.linesize(), (int)0, (int)height, (PointerPointer)new PointerPointer((Pointer)this.picture), (IntPointer)this.picture.linesize());
            } else {
                avcodec.avpicture_fill((avcodec.AVPicture)new avcodec.AVPicture((Pointer)this.picture), (BytePointer)data, (int)pixelFormat, (int)width, (int)height);
                this.picture.linesize(0, step);
                this.picture.format(pixelFormat);
                this.picture.width(width);
                this.picture.height(height);
            }
        }
        if ((this.oformat.flags() & 0x20) != 0) {
            if (image == null || image.length == 0) {
                return false;
            }
            avcodec.av_init_packet((avcodec.AVPacket)this.video_pkt);
            this.video_pkt.flags(this.video_pkt.flags() | 1);
            this.video_pkt.stream_index(this.video_st.index());
            this.video_pkt.data(new BytePointer((Pointer)this.picture));
            this.video_pkt.size(Loader.sizeof(avcodec.AVPicture.class));
        } else {
            avcodec.av_init_packet((avcodec.AVPacket)this.video_pkt);
            this.video_pkt.data(this.video_outbuf);
            this.video_pkt.size(this.video_outbuf_size);
            this.picture.quality(this.video_c.global_quality());
            ret = avcodec.avcodec_encode_video2((avcodec.AVCodecContext)this.video_c, (avcodec.AVPacket)this.video_pkt, (avutil.AVFrame)(image == null || image.length == 0 ? null : this.picture), (int[])this.got_video_packet);
            if (ret < 0) {
                throw new FrameRecorder.Exception("avcodec_encode_video2() error " + ret + ": Could not encode video packet.");
            }
            this.picture.pts(this.picture.pts() + 1L);
            if (this.got_video_packet[0] != 0) {
                if (this.video_pkt.pts() != avutil.AV_NOPTS_VALUE) {
                    this.video_pkt.pts(avutil.av_rescale_q((long)this.video_pkt.pts(), (avutil.AVRational)this.video_c.time_base(), (avutil.AVRational)this.video_st.time_base()));
                }
                if (this.video_pkt.dts() != avutil.AV_NOPTS_VALUE) {
                    this.video_pkt.dts(avutil.av_rescale_q((long)this.video_pkt.dts(), (avutil.AVRational)this.video_c.time_base(), (avutil.AVRational)this.video_st.time_base()));
                }
                this.video_pkt.stream_index(this.video_st.index());
            } else {
                return false;
            }
        }
        avformat.AVFormatContext aVFormatContext = this.oc;
        synchronized (aVFormatContext) {
            if (this.interleaved && this.audio_st != null) {
                ret = avformat.av_interleaved_write_frame((avformat.AVFormatContext)this.oc, (avcodec.AVPacket)this.video_pkt);
                if (ret < 0) {
                    throw new FrameRecorder.Exception("av_interleaved_write_frame() error " + ret + " while writing interleaved video frame.");
                }
            } else {
                ret = avformat.av_write_frame((avformat.AVFormatContext)this.oc, (avcodec.AVPacket)this.video_pkt);
                if (ret < 0) {
                    throw new FrameRecorder.Exception("av_write_frame() error " + ret + " while writing video frame.");
                }
            }
        }
        return (this.video_pkt.flags() & 1) == 1;
    }

    public boolean recordSamples(Buffer ... samples) throws FrameRecorder.Exception {
        return this.recordSamples(0, 0, samples);
    }

    public boolean recordSamples(int sampleRate, int audioChannels, Buffer ... samples) throws FrameRecorder.Exception {
        int ret;
        Buffer b;
        int i;
        if (this.audio_st == null) {
            throw new FrameRecorder.Exception("No audio output stream (Is audioChannels > 0 and has start() been called?)");
        }
        if (sampleRate <= 0) {
            sampleRate = this.audio_c.sample_rate();
        }
        if (audioChannels <= 0) {
            audioChannels = this.audio_c.channels();
        }
        int inputSize = samples != null ? samples[0].limit() - samples[0].position() : 0;
        int inputFormat = -1;
        int inputChannels = samples != null && samples.length > 1 ? 1 : audioChannels;
        int inputDepth = 0;
        int outputFormat = this.audio_c.sample_fmt();
        int outputChannels = this.samples_out.length > 1 ? 1 : this.audio_c.channels();
        int outputDepth = avutil.av_get_bytes_per_sample((int)outputFormat);
        if (samples != null && samples[0] instanceof ByteBuffer) {
            inputFormat = samples.length > 1 ? 5 : 0;
            inputDepth = 1;
            for (i = 0; i < samples.length; ++i) {
                b = (ByteBuffer)samples[i];
                if (this.samples_in[i] instanceof BytePointer && this.samples_in[i].capacity() >= inputSize && ((ByteBuffer)b).hasArray()) {
                    ((BytePointer)this.samples_in[i]).position(0).put(((ByteBuffer)b).array(), b.position(), inputSize);
                    continue;
                }
                this.samples_in[i] = new BytePointer((ByteBuffer)b);
            }
        } else if (samples != null && samples[0] instanceof ShortBuffer) {
            inputFormat = samples.length > 1 ? 6 : 1;
            inputDepth = 2;
            for (i = 0; i < samples.length; ++i) {
                b = (ShortBuffer)samples[i];
                if (this.samples_in[i] instanceof ShortPointer && this.samples_in[i].capacity() >= inputSize && ((ShortBuffer)b).hasArray()) {
                    ((ShortPointer)this.samples_in[i]).position(0).put(((ShortBuffer)b).array(), samples[i].position(), inputSize);
                    continue;
                }
                this.samples_in[i] = new ShortPointer((ShortBuffer)b);
            }
        } else if (samples != null && samples[0] instanceof IntBuffer) {
            inputFormat = samples.length > 1 ? 7 : 2;
            inputDepth = 4;
            for (i = 0; i < samples.length; ++i) {
                b = (IntBuffer)samples[i];
                if (this.samples_in[i] instanceof IntPointer && this.samples_in[i].capacity() >= inputSize && ((IntBuffer)b).hasArray()) {
                    ((IntPointer)this.samples_in[i]).position(0).put(((IntBuffer)b).array(), samples[i].position(), inputSize);
                    continue;
                }
                this.samples_in[i] = new IntPointer((IntBuffer)b);
            }
        } else if (samples != null && samples[0] instanceof FloatBuffer) {
            inputFormat = samples.length > 1 ? 8 : 3;
            inputDepth = 4;
            for (i = 0; i < samples.length; ++i) {
                b = (FloatBuffer)samples[i];
                if (this.samples_in[i] instanceof FloatPointer && this.samples_in[i].capacity() >= inputSize && ((FloatBuffer)b).hasArray()) {
                    ((FloatPointer)this.samples_in[i]).position(0).put(((FloatBuffer)b).array(), b.position(), inputSize);
                    continue;
                }
                this.samples_in[i] = new FloatPointer((FloatBuffer)b);
            }
        } else if (samples != null && samples[0] instanceof DoubleBuffer) {
            inputFormat = samples.length > 1 ? 9 : 4;
            inputDepth = 8;
            for (i = 0; i < samples.length; ++i) {
                b = (DoubleBuffer)samples[i];
                if (this.samples_in[i] instanceof DoublePointer && this.samples_in[i].capacity() >= inputSize && ((DoubleBuffer)b).hasArray()) {
                    ((DoublePointer)this.samples_in[i]).position(0).put(((DoubleBuffer)b).array(), b.position(), inputSize);
                    continue;
                }
                this.samples_in[i] = new DoublePointer((DoubleBuffer)b);
            }
        } else if (samples != null) {
            throw new FrameRecorder.Exception("Audio samples Buffer has unsupported type: " + samples);
        }
        if (this.samples_convert_ctx == null || this.samples_channels != audioChannels || this.samples_format != inputFormat || this.samples_rate != sampleRate) {
            this.samples_convert_ctx = swresample.swr_alloc_set_opts((swresample.SwrContext)this.samples_convert_ctx, (long)this.audio_c.channel_layout(), (int)outputFormat, (int)this.audio_c.sample_rate(), (long)avutil.av_get_default_channel_layout((int)audioChannels), (int)inputFormat, (int)sampleRate, (int)0, null);
            if (this.samples_convert_ctx == null) {
                throw new FrameRecorder.Exception("swr_alloc_set_opts() error: Cannot allocate the conversion context.");
            }
            ret = swresample.swr_init((swresample.SwrContext)this.samples_convert_ctx);
            if (ret < 0) {
                throw new FrameRecorder.Exception("swr_init() error " + ret + ": Cannot initialize the conversion context.");
            }
            this.samples_channels = audioChannels;
            this.samples_format = inputFormat;
            this.samples_rate = sampleRate;
        }
        for (i = 0; samples != null && i < samples.length; ++i) {
            this.samples_in[i].position(this.samples_in[i].position() * inputDepth).limit((this.samples_in[i].position() + inputSize) * inputDepth);
        }
        while (true) {
            int i2;
            int inputCount = samples != null ? (this.samples_in[0].limit() - this.samples_in[0].position()) / (inputChannels * inputDepth) : 0;
            int outputCount = (this.samples_out[0].limit() - this.samples_out[0].position()) / (outputChannels * outputDepth);
            inputCount = Math.min(inputCount, (outputCount * sampleRate + this.audio_c.sample_rate() - 1) / this.audio_c.sample_rate());
            for (i2 = 0; samples != null && i2 < samples.length; ++i2) {
                this.samples_in_ptr.put(i2, this.samples_in[i2]);
            }
            for (i2 = 0; i2 < this.samples_out.length; ++i2) {
                this.samples_out_ptr.put(i2, (Pointer)this.samples_out[i2]);
            }
            ret = swresample.swr_convert((swresample.SwrContext)this.samples_convert_ctx, (PointerPointer)this.samples_out_ptr, (int)outputCount, (PointerPointer)this.samples_in_ptr, (int)inputCount);
            if (ret < 0) {
                throw new FrameRecorder.Exception("swr_convert() error " + ret + ": Cannot convert audio samples.");
            }
            if (ret == 0) break;
            for (i2 = 0; samples != null && i2 < samples.length; ++i2) {
                this.samples_in[i2].position(this.samples_in[i2].position() + inputCount * inputChannels * inputDepth);
            }
            for (i2 = 0; i2 < this.samples_out.length; ++i2) {
                this.samples_out[i2].position(this.samples_out[i2].position() + ret * outputChannels * outputDepth);
            }
            if (samples != null && this.samples_out[0].position() < this.samples_out[0].limit()) continue;
            this.frame.nb_samples(this.audio_input_frame_size);
            avcodec.avcodec_fill_audio_frame((avutil.AVFrame)this.frame, (int)this.audio_c.channels(), (int)outputFormat, (BytePointer)this.samples_out[0], (int)this.samples_out[0].limit(), (int)0);
            for (i2 = 0; i2 < this.samples_out.length; ++i2) {
                this.frame.data(i2, this.samples_out[i2].position(0));
                this.frame.linesize(i2, this.samples_out[i2].limit());
            }
            this.frame.quality(this.audio_c.global_quality());
            this.record(this.frame);
        }
        return samples != null ? this.frame.key_frame() != 0 : this.record((avutil.AVFrame)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean record(avutil.AVFrame frame) throws FrameRecorder.Exception {
        avcodec.av_init_packet((avcodec.AVPacket)this.audio_pkt);
        this.audio_pkt.data(this.audio_outbuf);
        this.audio_pkt.size(this.audio_outbuf_size);
        int ret = avcodec.avcodec_encode_audio2((avcodec.AVCodecContext)this.audio_c, (avcodec.AVPacket)this.audio_pkt, (avutil.AVFrame)frame, (int[])this.got_audio_packet);
        if (ret < 0) {
            throw new FrameRecorder.Exception("avcodec_encode_audio2() error " + ret + ": Could not encode audio packet.");
        }
        if (frame != null) {
            frame.pts(frame.pts() + (long)frame.nb_samples());
        }
        if (this.got_audio_packet[0] != 0) {
            if (this.audio_pkt.pts() != avutil.AV_NOPTS_VALUE) {
                this.audio_pkt.pts(avutil.av_rescale_q((long)this.audio_pkt.pts(), (avutil.AVRational)this.audio_c.time_base(), (avutil.AVRational)this.audio_st.time_base()));
            }
            if (this.audio_pkt.dts() != avutil.AV_NOPTS_VALUE) {
                this.audio_pkt.dts(avutil.av_rescale_q((long)this.audio_pkt.dts(), (avutil.AVRational)this.audio_c.time_base(), (avutil.AVRational)this.audio_st.time_base()));
            }
        } else {
            return false;
        }
        this.audio_pkt.flags(this.audio_pkt.flags() | 1);
        this.audio_pkt.stream_index(this.audio_st.index());
        avformat.AVFormatContext aVFormatContext = this.oc;
        synchronized (aVFormatContext) {
            if (this.interleaved && this.video_st != null) {
                ret = avformat.av_interleaved_write_frame((avformat.AVFormatContext)this.oc, (avcodec.AVPacket)this.audio_pkt);
                if (ret < 0) {
                    throw new FrameRecorder.Exception("av_interleaved_write_frame() error " + ret + " while writing interleaved audio frame.");
                }
            } else {
                ret = avformat.av_write_frame((avformat.AVFormatContext)this.oc, (avcodec.AVPacket)this.audio_pkt);
                if (ret < 0) {
                    throw new FrameRecorder.Exception("av_write_frame() error " + ret + " while writing audio frame.");
                }
            }
        }
        return true;
    }

    static {
        try {
            FFmpegFrameRecorder.tryLoad();
        }
        catch (FrameRecorder.Exception exception) {
            // empty catch block
        }
    }
}

