/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Frame {
    public boolean keyFrame;
    public static final int DEPTH_BYTE = -8;
    public static final int DEPTH_UBYTE = 8;
    public static final int DEPTH_SHORT = -16;
    public static final int DEPTH_USHORT = 16;
    public static final int DEPTH_INT = -32;
    public static final int DEPTH_LONG = -64;
    public static final int DEPTH_FLOAT = 32;
    public static final int DEPTH_DOUBLE = 64;
    public int imageWidth;
    public int imageHeight;
    public int imageDepth;
    public int imageChannels;
    public int imageStride;
    public Buffer[] image;
    public int sampleRate;
    public int audioChannels;
    public Buffer[] samples;
    public Object opaque;

    public Frame() {
    }

    public Frame(int width, int height, int depth, int channels) {
        int pixelSize = Math.abs(depth) / 8;
        this.imageWidth = width;
        this.imageHeight = height;
        this.imageDepth = depth;
        this.imageChannels = channels;
        this.imageStride = (this.imageWidth * this.imageChannels * pixelSize + 7 & 0xFFFFFFF8) / pixelSize;
        this.image = new Buffer[1];
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.imageHeight * this.imageStride * pixelSize).order(ByteOrder.nativeOrder());
        switch (this.imageDepth) {
            case -8: 
            case 8: {
                this.image[0] = buffer;
                break;
            }
            case -16: 
            case 16: {
                this.image[0] = buffer.asShortBuffer();
                break;
            }
            case -32: {
                this.image[0] = buffer.asIntBuffer();
                break;
            }
            case -64: {
                this.image[0] = buffer.asLongBuffer();
                break;
            }
            case 32: {
                this.image[0] = buffer.asFloatBuffer();
                break;
            }
            case 64: {
                this.image[0] = buffer.asDoubleBuffer();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported depth value: " + this.imageDepth);
            }
        }
    }
}

