/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko;

import java.util.ArrayList;
import java.util.List;
import org.htmlunit.cyberneko.xerces.xni.Augmentations;
import org.htmlunit.cyberneko.xerces.xni.XMLDocumentHandler;
import org.htmlunit.cyberneko.xerces.xni.XMLString;

class LostText {
    private final List<Entry> entries = new ArrayList<Entry>();

    LostText() {
    }

    public void add(XMLString text, Augmentations augs) {
        if (!this.entries.isEmpty() || text.toString().trim().length() > 0) {
            this.entries.add(new Entry(text, augs));
        }
    }

    public void refeed(XMLDocumentHandler tagBalancer) {
        for (Entry entry : new ArrayList<Entry>(this.entries)) {
            tagBalancer.characters(entry.text_, entry.augs_);
        }
        this.entries.clear();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public void clear() {
        this.entries.clear();
    }

    private static final class Entry {
        private final XMLString text_;
        private Augmentations augs_;

        public Entry(XMLString text, Augmentations augs) {
            char[] chars = new char[text.length];
            System.arraycopy(text.ch, text.offset, chars, 0, text.length);
            this.text_ = new XMLString(chars, 0, chars.length);
            this.augs_ = augs;
        }
    }
}

