/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.httpfileupload;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.httpfileupload.UploadProgressListener;
import org.jivesoftware.smackx.httpfileupload.UploadService;
import org.jivesoftware.smackx.httpfileupload.element.Slot;
import org.jivesoftware.smackx.httpfileupload.element.SlotRequest;
import org.jivesoftware.smackx.httpfileupload.element.SlotRequest_V0_2;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.Jid;

public final class HttpFileUploadManager
extends Manager {
    public static final String NAMESPACE = "urn:xmpp:http:upload:0";
    public static final String NAMESPACE_0_2 = "urn:xmpp:http:upload";
    private static final Logger LOGGER = Logger.getLogger(HttpFileUploadManager.class.getName());
    private static final Map<XMPPConnection, HttpFileUploadManager> INSTANCES;
    private UploadService defaultUploadService;
    private SSLSocketFactory tlsSocketFactory;

    public static synchronized HttpFileUploadManager getInstanceFor(XMPPConnection connection) {
        HttpFileUploadManager httpFileUploadManager = INSTANCES.get(connection);
        if (httpFileUploadManager == null) {
            httpFileUploadManager = new HttpFileUploadManager(connection);
            INSTANCES.put(connection, httpFileUploadManager);
        }
        return httpFileUploadManager;
    }

    private HttpFileUploadManager(XMPPConnection connection) {
        super(connection);
        connection.addConnectionListener(new ConnectionListener(){

            public void authenticated(XMPPConnection connection, boolean resumed) {
                if (resumed) {
                    return;
                }
                try {
                    HttpFileUploadManager.this.discoverUploadService();
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                    LOGGER.log(Level.WARNING, "Error during discovering HTTP File Upload service", e);
                }
            }
        });
    }

    private static UploadService uploadServiceFrom(DiscoverInfo discoverInfo) {
        UploadService.Version version;
        assert (HttpFileUploadManager.containsHttpFileUploadNamespace(discoverInfo));
        if (discoverInfo.containsFeature((CharSequence)NAMESPACE)) {
            version = UploadService.Version.v0_3;
        } else if (discoverInfo.containsFeature((CharSequence)NAMESPACE_0_2)) {
            version = UploadService.Version.v0_2;
        } else {
            throw new AssertionError();
        }
        DomainBareJid address = discoverInfo.getFrom().asDomainBareJid();
        DataForm dataForm = DataForm.from((StanzaView)discoverInfo);
        if (dataForm == null) {
            return new UploadService(address, version);
        }
        FormField field = dataForm.getField("max-file-size");
        if (field == null) {
            return new UploadService(address, version);
        }
        String maxFileSizeValue = field.getFirstValue();
        if (maxFileSizeValue == null) {
            return new UploadService(address, version);
        }
        Long maxFileSize = Long.valueOf(maxFileSizeValue);
        return new UploadService(address, version, maxFileSize);
    }

    public boolean discoverUploadService() throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection());
        List servicesDiscoverInfo = sdm.findServicesDiscoverInfo(NAMESPACE, true, true);
        if (servicesDiscoverInfo.isEmpty() && (servicesDiscoverInfo = sdm.findServicesDiscoverInfo(NAMESPACE_0_2, true, true)).isEmpty()) {
            return false;
        }
        DiscoverInfo discoverInfo = (DiscoverInfo)servicesDiscoverInfo.get(0);
        this.defaultUploadService = HttpFileUploadManager.uploadServiceFrom(discoverInfo);
        return true;
    }

    public boolean isUploadServiceDiscovered() {
        return this.defaultUploadService != null;
    }

    public UploadService getDefaultUploadService() {
        return this.defaultUploadService;
    }

    public URL uploadFile(File file) throws InterruptedException, XMPPException.XMPPErrorException, SmackException, IOException {
        return this.uploadFile(file, null);
    }

    public URL uploadFile(File file, UploadProgressListener listener) throws InterruptedException, XMPPException.XMPPErrorException, SmackException, IOException {
        if (!file.isFile()) {
            throw new FileNotFoundException("The path " + file.getAbsolutePath() + " is not a file");
        }
        Slot slot = this.requestSlot(file.getName(), file.length(), "application/octet-stream");
        long fileSize = file.length();
        FileInputStream fis = new FileInputStream(file);
        this.upload(fis, fileSize, slot, listener);
        return slot.getGetUrl();
    }

    public URL uploadFile(InputStream inputStream, String fileName, long fileSize) throws XMPPException.XMPPErrorException, InterruptedException, SmackException, IOException {
        return this.uploadFile(inputStream, fileName, fileSize, null);
    }

    public URL uploadFile(InputStream inputStream, String fileName, long fileSize, UploadProgressListener listener) throws XMPPException.XMPPErrorException, InterruptedException, SmackException, IOException {
        Objects.requireNonNull(inputStream, "Input Stream cannot be null");
        Objects.requireNonNull(fileName, "Filename Stream cannot be null");
        if (fileSize < 0L) {
            throw new IllegalArgumentException("File size cannot be negative");
        }
        Slot slot = this.requestSlot(fileName, fileSize, "application/octet-stream");
        this.upload(inputStream, fileSize, slot, listener);
        return slot.getGetUrl();
    }

    public Slot requestSlot(String filename, long fileSize) throws InterruptedException, XMPPException.XMPPErrorException, SmackException {
        return this.requestSlot(filename, fileSize, null, null);
    }

    public Slot requestSlot(String filename, long fileSize, String contentType) throws SmackException, InterruptedException, XMPPException.XMPPErrorException {
        return this.requestSlot(filename, fileSize, contentType, null);
    }

    public Slot requestSlot(String filename, long fileSize, String contentType, DomainBareJid uploadServiceAddress) throws SmackException, InterruptedException, XMPPException.XMPPErrorException {
        SlotRequest slotRequest;
        UploadService uploadService;
        XMPPConnection connection = this.connection();
        UploadService defaultUploadService = this.defaultUploadService;
        if (uploadServiceAddress == null) {
            uploadService = defaultUploadService;
        } else if (defaultUploadService != null && defaultUploadService.getAddress().equals((CharSequence)uploadServiceAddress)) {
            uploadService = defaultUploadService;
        } else {
            DiscoverInfo discoverInfo = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection).discoverInfo((Jid)uploadServiceAddress);
            if (!HttpFileUploadManager.containsHttpFileUploadNamespace(discoverInfo)) {
                throw new IllegalArgumentException("There is no HTTP upload service running at the given address '" + uploadServiceAddress + '\'');
            }
            uploadService = HttpFileUploadManager.uploadServiceFrom(discoverInfo);
        }
        if (uploadService == null) {
            throw new SmackException.SmackMessageException("No upload service specified and also none discovered.");
        }
        if (!uploadService.acceptsFileOfSize(fileSize)) {
            throw new IllegalArgumentException("Requested file size " + fileSize + " is greater than max allowed size " + uploadService.getMaxFileSize());
        }
        switch (uploadService.getVersion()) {
            case v0_3: {
                slotRequest = new SlotRequest(uploadService.getAddress(), filename, fileSize, contentType);
                break;
            }
            case v0_2: {
                slotRequest = new SlotRequest_V0_2(uploadService.getAddress(), filename, fileSize, contentType);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return (Slot)connection.createStanzaCollectorAndSend((IQ)slotRequest).nextResultOrThrow();
    }

    public void setTlsContext(SSLContext tlsContext) {
        if (tlsContext == null) {
            return;
        }
        this.tlsSocketFactory = tlsContext.getSocketFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void upload(InputStream iStream, long fileSize, Slot slot, UploadProgressListener listener) throws IOException {
        URL putUrl = slot.getPutUrl();
        XMPPConnection connection = this.connection();
        HttpURLConnection urlConnection = HttpFileUploadManager.createURLConnection(connection, putUrl);
        urlConnection.setRequestMethod("PUT");
        urlConnection.setUseCaches(false);
        urlConnection.setDoOutput(true);
        urlConnection.setFixedLengthStreamingMode(fileSize);
        urlConnection.setRequestProperty("Content-Type", "application/octet-stream");
        for (Map.Entry<String, String> header : slot.getHeaders().entrySet()) {
            urlConnection.setRequestProperty(header.getKey(), header.getValue());
        }
        SSLSocketFactory tlsSocketFactory = this.tlsSocketFactory;
        if (tlsSocketFactory != null && urlConnection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsUrlConnection = (HttpsURLConnection)urlConnection;
            httpsUrlConnection.setSSLSocketFactory(tlsSocketFactory);
        }
        try {
            OutputStream outputStream = urlConnection.getOutputStream();
            long bytesSend = 0L;
            if (listener != null) {
                listener.onUploadProgress(0L, fileSize);
            }
            BufferedInputStream inputStream = new BufferedInputStream(iStream);
            byte[] buffer = new byte[4096];
            try {
                int bytesRead;
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                    bytesSend += (long)bytesRead;
                    if (listener == null) continue;
                    listener.onUploadProgress(bytesSend, fileSize);
                }
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Exception while closing input stream", e);
                }
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Exception while closing output stream", e);
                }
            }
            int status = urlConnection.getResponseCode();
            switch (status) {
                case 200: 
                case 201: 
                case 204: {
                    return;
                }
                default: {
                    throw new IOException("Error response " + status + " from server during file upload: " + urlConnection.getResponseMessage() + ", file size: " + fileSize + ", put URL: " + putUrl);
                }
            }
        }
        finally {
            urlConnection.disconnect();
        }
    }

    private static HttpURLConnection createURLConnection(XMPPConnection connection, URL putUrl) throws IOException {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(putUrl);
        ProxyInfo proxyInfo = HttpFileUploadManager.fetchProxyInfo(connection);
        if (proxyInfo != null) {
            return HttpFileUploadManager.createProxiedURLConnection(proxyInfo, putUrl);
        }
        return (HttpURLConnection)putUrl.openConnection();
    }

    private static HttpURLConnection createProxiedURLConnection(ProxyInfo proxyInfo, URL putUrl) throws IOException {
        Objects.requireNonNull(proxyInfo);
        Objects.requireNonNull(putUrl);
        return (HttpURLConnection)putUrl.openConnection(proxyInfo.toJavaProxy());
    }

    private static ProxyInfo fetchProxyInfo(XMPPConnection connection) {
        if (!(connection instanceof AbstractXMPPConnection)) {
            return null;
        }
        AbstractXMPPConnection xmppConnection = (AbstractXMPPConnection)connection;
        return xmppConnection.getConfiguration().getProxyInfo();
    }

    public static UploadService.Version namespaceToVersion(String namespace) {
        UploadService.Version version;
        switch (namespace) {
            case "urn:xmpp:http:upload:0": {
                version = UploadService.Version.v0_3;
                break;
            }
            case "urn:xmpp:http:upload": {
                version = UploadService.Version.v0_2;
                break;
            }
            default: {
                version = null;
            }
        }
        return version;
    }

    private static boolean containsHttpFileUploadNamespace(DiscoverInfo discoverInfo) {
        return discoverInfo.containsFeature((CharSequence)NAMESPACE) || discoverInfo.containsFeature((CharSequence)NAMESPACE_0_2);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                HttpFileUploadManager.getInstanceFor(connection);
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, HttpFileUploadManager>();
    }
}

