/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.message_markup.element;

import java.util.Collections;
import java.util.Set;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.message_markup.element.MarkupElement;

public class SpanElement
extends MarkupElement.NonEmptyChildElement {
    public static final String ELEMENT = "span";
    private final Set<SpanStyle> styles;
    public static final String emphasis = "emphasis";
    public static final String code = "code";
    public static final String deleted = "deleted";

    public SpanElement(int start, int end, Set<SpanStyle> styles) {
        super(start, end);
        this.styles = Collections.unmodifiableSet(styles);
    }

    public Set<SpanStyle> getStyles() {
        return this.styles;
    }

    public String getElementName() {
        return ELEMENT;
    }

    @Override
    protected void appendInnerXml(XmlStringBuilder xml) {
        for (SpanStyle style : this.getStyles()) {
            xml.emptyElement((Enum)style);
        }
    }

    public static enum SpanStyle {
        emphasis,
        code,
        deleted;

    }
}

