/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.push_notifications;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.push_notifications.element.DisablePushNotificationsIQ;
import org.jivesoftware.smackx.push_notifications.element.EnablePushNotificationsIQ;
import org.jxmpp.jid.Jid;

public final class PushNotificationsManager
extends Manager {
    private static final Map<XMPPConnection, PushNotificationsManager> INSTANCES;

    public static synchronized PushNotificationsManager getInstanceFor(XMPPConnection connection) {
        PushNotificationsManager pushNotificationsManager = INSTANCES.get(connection);
        if (pushNotificationsManager == null) {
            pushNotificationsManager = new PushNotificationsManager(connection);
            INSTANCES.put(connection, pushNotificationsManager);
        }
        return pushNotificationsManager;
    }

    private PushNotificationsManager(XMPPConnection connection) {
        super(connection);
    }

    public boolean isSupported() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection()).accountSupportsFeatures(new CharSequence[]{"urn:xmpp:push:0"});
    }

    public boolean enable(Jid pushJid, String node) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.enable(pushJid, node, null);
    }

    public boolean enable(Jid pushJid, String node, HashMap<String, String> publishOptions) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        EnablePushNotificationsIQ enablePushNotificationsIQ = new EnablePushNotificationsIQ(pushJid, node, publishOptions);
        return this.changePushNotificationsStatus(enablePushNotificationsIQ);
    }

    public boolean disableAll(Jid pushJid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.disable(pushJid, null);
    }

    public boolean disable(Jid pushJid, String node) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DisablePushNotificationsIQ disablePushNotificationsIQ = new DisablePushNotificationsIQ(pushJid, node);
        return this.changePushNotificationsStatus(disablePushNotificationsIQ);
    }

    private boolean changePushNotificationsStatus(IQ iq) throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, XMPPException.XMPPErrorException {
        XMPPConnection connection = this.connection();
        IQ responseIQ = (IQ)connection.createStanzaCollectorAndSend(iq).nextResultOrThrow();
        return responseIQ.getType() != IQ.Type.error;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                PushNotificationsManager.getInstanceFor(connection);
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, PushNotificationsManager>();
    }
}

