/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.spoiler.element;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class SpoilerElement
implements ExtensionElement {
    public static final String ELEMENT = "spoiler";
    public static final String NAMESPACE = "urn:xmpp:spoiler:0";
    public static final SpoilerElement EMPTY = new SpoilerElement(null, null);
    private final String hint;
    private final String language;

    public SpoilerElement(String language, String hint) {
        if (StringUtils.isNotEmpty((CharSequence)language) && StringUtils.isNullOrEmpty((CharSequence)hint)) {
            throw new IllegalArgumentException("Hint cannot be null or empty if language is not empty.");
        }
        this.language = language;
        this.hint = hint;
    }

    public String getHint() {
        return this.hint;
    }

    public static void addSpoiler(Message message) {
        message.addExtension((ExtensionElement)EMPTY);
    }

    public static void addSpoiler(Message message, String hint) {
        message.addExtension((ExtensionElement)new SpoilerElement(null, hint));
    }

    public static void addSpoiler(Message message, String lang, String hint) {
        message.addExtension((ExtensionElement)new SpoilerElement(lang, hint));
    }

    public static boolean containsSpoiler(Message message) {
        return message.hasExtension(ELEMENT, NAMESPACE);
    }

    public static Map<String, String> getSpoilers(Message message) {
        if (!SpoilerElement.containsSpoiler(message)) {
            return Collections.emptyMap();
        }
        List spoilers = message.getExtensions(ELEMENT, NAMESPACE);
        HashMap<String, String> map = new HashMap<String, String>();
        for (ExtensionElement e : spoilers) {
            SpoilerElement s = (SpoilerElement)e;
            if (s.getLanguage() == null || s.getLanguage().equals("")) {
                map.put("", s.getHint());
                continue;
            }
            map.put(s.getLanguage(), s.getHint());
        }
        return map;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public CharSequence toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder((FullyQualifiedElement)this, enclosingNamespace);
        if (this.getHint() == null) {
            xml.closeEmptyElement();
        } else {
            xml.rightAngleBracket();
            xml.append((CharSequence)this.getHint());
            xml.closeElement((NamedElement)this);
        }
        return xml;
    }
}

