/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.stanza_content_encryption.element;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.address.packet.MultipleAddresses;
import org.jivesoftware.smackx.sid.element.StanzaIdElement;
import org.jivesoftware.smackx.stanza_content_encryption.element.AffixElement;
import org.jivesoftware.smackx.stanza_content_encryption.element.FromAffixElement;
import org.jivesoftware.smackx.stanza_content_encryption.element.PayloadElement;
import org.jivesoftware.smackx.stanza_content_encryption.element.RandomPaddingAffixElement;
import org.jivesoftware.smackx.stanza_content_encryption.element.TimestampAffixElement;
import org.jivesoftware.smackx.stanza_content_encryption.element.ToAffixElement;
import org.jxmpp.jid.Jid;

public class ContentElement
implements ExtensionElement {
    private static final String NAMESPACE_UNVERSIONED = "urn:xmpp:sce";
    public static final String NAMESPACE_0 = "urn:xmpp:sce:0";
    public static final String NAMESPACE = "urn:xmpp:sce:0";
    public static final String ELEMENT = "content";
    public static final QName QNAME = new QName("urn:xmpp:sce:0", "content");
    private final PayloadElement payload;
    private final List<AffixElement> affixElements;

    ContentElement(PayloadElement payload, List<AffixElement> affixElements) {
        this.payload = payload;
        this.affixElements = Collections.unmodifiableList(affixElements);
    }

    public PayloadElement getPayload() {
        return this.payload;
    }

    public List<AffixElement> getAffixElements() {
        return this.affixElements;
    }

    public String getNamespace() {
        return "urn:xmpp:sce:0";
    }

    public String getElementName() {
        return ELEMENT;
    }

    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder xml = new XmlStringBuilder((ExtensionElement)this).rightAngleBracket();
        xml.append(this.affixElements);
        xml.append((Element)this.payload);
        return xml.closeElement((NamedElement)this);
    }

    public QName getQName() {
        return QNAME;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final Set<String> BLACKLISTED_NAMESPACES = Collections.singleton("urn:xmpp:hints");
        private static final Set<QName> BLACKLISTED_QNAMES = Collections.unmodifiableSet(new HashSet<QName>(Arrays.asList(StanzaIdElement.QNAME, MultipleAddresses.QNAME)));
        private FromAffixElement from = null;
        private TimestampAffixElement timestamp = null;
        private RandomPaddingAffixElement rpad = null;
        private final List<AffixElement> otherAffixElements = new ArrayList<AffixElement>();
        private final List<ExtensionElement> payloadItems = new ArrayList<ExtensionElement>();

        private Builder() {
        }

        public Builder addTo(Jid jid) {
            return this.addTo(new ToAffixElement(jid));
        }

        public Builder addTo(ToAffixElement to) {
            this.otherAffixElements.add((AffixElement)Objects.requireNonNull((Object)to, (String)"'to' affix element MUST NOT be null."));
            return this;
        }

        public Builder setFrom(Jid jid) {
            return this.setFrom(new FromAffixElement(jid));
        }

        public Builder setFrom(FromAffixElement from) {
            this.from = (FromAffixElement)Objects.requireNonNull((Object)from, (String)"'form' affix element MUST NOT be null.");
            return this;
        }

        public Builder setTimestamp(Date date) {
            return this.setTimestamp(new TimestampAffixElement(date));
        }

        public Builder setTimestamp(TimestampAffixElement timestamp) {
            this.timestamp = (TimestampAffixElement)Objects.requireNonNull((Object)timestamp, (String)"'time' affix element MUST NOT be null.");
            return this;
        }

        public Builder setRandomPadding() {
            this.rpad = new RandomPaddingAffixElement();
            return this;
        }

        public Builder setRandomPadding(String padding) {
            return this.setRandomPadding(new RandomPaddingAffixElement(padding));
        }

        public Builder setRandomPadding(RandomPaddingAffixElement padding) {
            this.rpad = (RandomPaddingAffixElement)Objects.requireNonNull((Object)padding, (String)"'rpad' affix element MUST NOT be empty.");
            return this;
        }

        public Builder addFurtherAffixElement(AffixElement customAffixElement) {
            this.otherAffixElements.add((AffixElement)Objects.requireNonNull((Object)customAffixElement, (String)"Custom affix element MUST NOT be null."));
            return this;
        }

        public Builder addPayloadItem(ExtensionElement payloadItem) {
            Objects.requireNonNull((Object)payloadItem, (String)"Payload item MUST NOT be null.");
            this.payloadItems.add(Builder.checkForIllegalPayloadsAndPossiblyThrow(payloadItem));
            return this;
        }

        public ContentElement build() {
            List<AffixElement> allAffixElements = this.collectAffixElements();
            PayloadElement payloadElement = new PayloadElement(this.payloadItems);
            return new ContentElement(payloadElement, allAffixElements);
        }

        private static ExtensionElement checkForIllegalPayloadsAndPossiblyThrow(ExtensionElement payloadItem) {
            QName qName = payloadItem.getQName();
            if (BLACKLISTED_QNAMES.contains(qName)) {
                throw new IllegalArgumentException("Element identified by " + qName + " is not allowed as payload item. See https://xmpp.org/extensions/xep-0420.html#server-processed");
            }
            String namespace = payloadItem.getNamespace();
            if (BLACKLISTED_NAMESPACES.contains(namespace)) {
                throw new IllegalArgumentException("Elements of namespace '" + namespace + "' are not allowed as payload items. See https://xmpp.org/extensions/xep-0420.html#server-processed");
            }
            return payloadItem;
        }

        private List<AffixElement> collectAffixElements() {
            ArrayList<AffixElement> allAffixElements = new ArrayList<AffixElement>(Arrays.asList(this.rpad, this.from, this.timestamp));
            allAffixElements.addAll(this.otherAffixElements);
            return allAffixElements;
        }
    }
}

