/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterGroup;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.Jid;

public final class RosterEntry
extends Manager {
    private RosterPacket.Item item;
    private final Roster roster;

    RosterEntry(RosterPacket.Item item, Roster roster, XMPPConnection connection) {
        super(connection);
        this.item = item;
        this.roster = roster;
    }

    @Deprecated
    public String getUser() {
        return this.getJid().toString();
    }

    public BareJid getJid() {
        return this.item.getJid();
    }

    public String getName() {
        return this.item.getName();
    }

    public synchronized void setName(String name) throws SmackException.NotConnectedException, SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException {
        if (name != null && name.equals(this.getName())) {
            return;
        }
        RosterPacket packet = new RosterPacket();
        packet.setType(IQ.Type.set);
        packet.addRosterItem(RosterEntry.toRosterItem(this, name));
        this.connection().createStanzaCollectorAndSend((IQ)packet).nextResultOrThrow();
        this.item.setName(name);
    }

    void updateItem(RosterPacket.Item item) {
        assert (item != null);
        this.item = item;
    }

    public boolean isApproved() {
        return this.item.isApproved();
    }

    public List<RosterGroup> getGroups() {
        ArrayList<RosterGroup> results = new ArrayList<RosterGroup>();
        for (RosterGroup group : this.roster.getGroups()) {
            if (!group.contains(this)) continue;
            results.add(group);
        }
        return results;
    }

    public RosterPacket.ItemType getType() {
        return this.item.getItemType();
    }

    public boolean isSubscriptionPending() {
        return this.item.isSubscriptionPending();
    }

    public boolean canSeeMyPresence() {
        switch (this.getType()) {
            case from: 
            case both: {
                return true;
            }
        }
        return false;
    }

    public boolean canSeeHisPresence() {
        switch (this.getType()) {
            case both: 
            case to: {
                return true;
            }
        }
        return false;
    }

    public void cancelSubscription() throws SmackException.NotConnectedException, InterruptedException {
        XMPPConnection connection = this.connection();
        Presence unsubscribed = ((PresenceBuilder)connection.getStanzaFactory().buildPresenceStanza().to((Jid)this.item.getJid())).ofType(Presence.Type.unsubscribed).build();
        connection.sendStanza((Stanza)unsubscribed);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.getName() != null) {
            buf.append(this.getName()).append(": ");
        }
        buf.append((CharSequence)this.getJid());
        List<RosterGroup> groups = this.getGroups();
        if (!groups.isEmpty()) {
            buf.append(" [");
            Iterator iter = groups.iterator();
            RosterGroup group = (RosterGroup)((Object)iter.next());
            buf.append(group.getName());
            while (iter.hasNext()) {
                buf.append(", ");
                group = (RosterGroup)((Object)iter.next());
                buf.append(group.getName());
            }
            buf.append(']');
        }
        return buf.toString();
    }

    public int hashCode() {
        return this.getJid().hashCode();
    }

    public boolean equals(Object object) {
        return EqualsUtil.equals((Object)((Object)this), (Object)object, (e, o) -> e.append((Object)this.getJid(), (Object)o.getJid()));
    }

    public boolean equalsDeep(Object obj) {
        return EqualsUtil.equals((Object)((Object)this), (Object)obj, (e, o) -> e.append((Object)this.item, (Object)o.item));
    }

    static RosterPacket.Item toRosterItem(RosterEntry entry) {
        return RosterEntry.toRosterItem(entry, entry.getName(), false);
    }

    static RosterPacket.Item toRosterItem(RosterEntry entry, String name) {
        return RosterEntry.toRosterItem(entry, name, false);
    }

    static RosterPacket.Item toRosterItem(RosterEntry entry, boolean includeAskAttribute) {
        return RosterEntry.toRosterItem(entry, entry.getName(), includeAskAttribute);
    }

    private static RosterPacket.Item toRosterItem(RosterEntry entry, String name, boolean includeAskAttribute) {
        RosterPacket.Item item = new RosterPacket.Item(entry.getJid(), name);
        item.setItemType(entry.getType());
        if (includeAskAttribute) {
            item.setSubscriptionPending(entry.isSubscriptionPending());
        }
        item.setApproved(entry.isApproved());
        for (RosterGroup group : entry.getGroups()) {
            item.addGroupName(group.getName());
        }
        return item;
    }
}

