/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import java.io.IOException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.SimpleIQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.Jid;

public class OfferConfirmation
extends SimpleIQ {
    private String userJID;
    private long sessionID;

    public OfferConfirmation() {
        super("offer-confirmation", "http://jabber.org/protocol/workgroup");
    }

    public String getUserJID() {
        return this.userJID;
    }

    public void setUserJID(String userJID) {
        this.userJID = userJID;
    }

    public long getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(long sessionID) {
        this.sessionID = sessionID;
    }

    public void notifyService(XMPPConnection con, Jid workgroup, String createdRoomName) throws SmackException.NotConnectedException, InterruptedException {
        NotifyServicePacket packet = new NotifyServicePacket(workgroup, createdRoomName);
        con.sendStanza((Stanza)packet);
    }

    private static class NotifyServicePacket
    extends IQ {
        String roomName;

        NotifyServicePacket(Jid workgroup, String roomName) {
            super("offer-confirmation", "http://jabber.org/protocol/workgroup");
            this.setTo(workgroup);
            this.setType(IQ.Type.result);
            this.roomName = roomName;
        }

        protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
            xml.attribute("roomname", this.roomName);
            xml.setEmptyElement();
            return xml;
        }
    }

    public static class Provider
    extends IQProvider<OfferConfirmation> {
        public OfferConfirmation parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
            OfferConfirmation confirmation = new OfferConfirmation();
            boolean done = false;
            while (!done) {
                parser.next();
                if (parser.getEventType() == XmlPullParser.Event.START_ELEMENT && "user-jid".equals(parser.getName())) {
                    confirmation.setUserJID(parser.nextText());
                    continue;
                }
                if (parser.getEventType() == XmlPullParser.Event.START_ELEMENT && "session-id".equals(parser.getName())) {
                    confirmation.setSessionID(Long.valueOf(parser.nextText()));
                    continue;
                }
                if (parser.getEventType() != XmlPullParser.Event.END_ELEMENT || !"offer-confirmation".equals(parser.getName())) continue;
                done = true;
            }
            return confirmation;
        }
    }
}

