/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xroster.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.RosterGroup;
import org.jivesoftware.smackx.xroster.RemoteRosterEntry;
import org.jxmpp.jid.Jid;

public class RosterExchange
implements ExtensionElement {
    private final List<RemoteRosterEntry> remoteRosterEntries = new ArrayList<RemoteRosterEntry>();

    public RosterExchange() {
    }

    public RosterExchange(Roster roster) {
        for (RosterEntry rosterEntry : roster.getEntries()) {
            this.addRosterEntry(rosterEntry);
        }
    }

    public void addRosterEntry(RosterEntry rosterEntry) {
        ArrayList<String> groupNamesList = new ArrayList<String>();
        for (RosterGroup group : rosterEntry.getGroups()) {
            groupNamesList.add(group.getName());
        }
        String[] groupNames = groupNamesList.toArray(new String[groupNamesList.size()]);
        RemoteRosterEntry remoteRosterEntry = new RemoteRosterEntry((Jid)rosterEntry.getJid(), rosterEntry.getName(), groupNames);
        this.addRosterEntry(remoteRosterEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRosterEntry(RemoteRosterEntry remoteRosterEntry) {
        List<RemoteRosterEntry> list = this.remoteRosterEntries;
        synchronized (list) {
            this.remoteRosterEntries.add(remoteRosterEntry);
        }
    }

    public String getElementName() {
        return "x";
    }

    public String getNamespace() {
        return "jabber:x:roster";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<RemoteRosterEntry> getRosterEntries() {
        List<RemoteRosterEntry> list = this.remoteRosterEntries;
        synchronized (list) {
            List<RemoteRosterEntry> entries = Collections.unmodifiableList(new ArrayList<RemoteRosterEntry>(this.remoteRosterEntries));
            return entries.iterator();
        }
    }

    public int getEntryCount() {
        return this.remoteRosterEntries.size();
    }

    public String toXML(XmlEnvironment enclosingNamespace) {
        StringBuilder buf = new StringBuilder();
        buf.append('<').append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\">");
        Iterator<RemoteRosterEntry> i = this.getRosterEntries();
        while (i.hasNext()) {
            RemoteRosterEntry remoteRosterEntry = i.next();
            buf.append(remoteRosterEntry.toXML());
        }
        buf.append("</").append(this.getElementName()).append('>');
        return buf.toString();
    }
}

