/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.internal;

import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jivesoftware.smack.util.RandomUtil;
import org.jivesoftware.smackx.omemo.util.OmemoMessageBuilder;

public class OmemoAesCipher {
    private static byte[] performCipherOperation(CipherOpmode opmode, byte[] input, byte[] key, byte[] initializationVector) throws IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(initializationVector);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(opmode.opmodeInt, (Key)secretKey, ivSpec);
        byte[] ciphertext = cipher.doFinal(input);
        return ciphertext;
    }

    public static byte[] decryptAesGcmNoPadding(byte[] ciphertext, byte[] key, byte[] initializationVector) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        return OmemoAesCipher.performCipherOperation(CipherOpmode.decrypt, ciphertext, key, initializationVector);
    }

    public static byte[] encryptAesGcmNoPadding(byte[] plaintext, byte[] key, byte[] initializationVector) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return OmemoAesCipher.performCipherOperation(CipherOpmode.encrypt, plaintext, key, initializationVector);
    }

    public static byte[] encryptAesGcmNoPadding(String plaintext, byte[] key, byte[] initializationVector) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] plaintextBytes = plaintext.getBytes(StandardCharsets.UTF_8);
        return OmemoAesCipher.encryptAesGcmNoPadding(plaintextBytes, key, initializationVector);
    }

    static {
        byte[] iv = OmemoMessageBuilder.generateIv();
        byte[] key = new byte[16];
        RandomUtil.fillWithSecureRandom((byte[])key);
        try {
            OmemoAesCipher.encryptAesGcmNoPadding("This is just a test", key, iv);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            String message = "Unable to perform AES/GCM/NoPadding operation requires by OMEMO. Ensure that a suitable crypto provider for is available. For example Bouncycastle on Android (BouncyCastleProvider)";
            throw new AssertionError((Object)message);
        }
    }

    private static enum CipherOpmode {
        encrypt(1),
        decrypt(2);

        public final int opmodeInt;

        private CipherOpmode(int opmodeInt) {
            this.opmodeInt = opmodeInt;
        }
    }
}

