/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.nfctools.ndef.NdefMessage;
import org.nfctools.ndef.NdefRecord;
import org.nfctools.ndef.NdefRecordDecoder;
import org.nfctools.ndef.Record;
import org.nfctools.ndef.RecordUtils;

public class NdefMessageDecoder {
    private NdefRecordDecoder ndefRecordDecoder;

    public NdefMessageDecoder(NdefRecordDecoder ndefRecordDecoder) {
        this.ndefRecordDecoder = ndefRecordDecoder;
    }

    public List<Record> decodeToRecords(byte[] payload) {
        return this.decodeToRecords(this.decode(payload));
    }

    public List<Record> decodeToRecords(InputStream in) {
        return this.decodeToRecords(this.decode(in));
    }

    public List<Record> decodeToRecords(NdefMessage ndefMessage) {
        ArrayList<Record> records = new ArrayList<Record>();
        NdefRecord[] ndefRecords = ndefMessage.getNdefRecords();
        block0: for (int i = 0; i < ndefRecords.length; ++i) {
            NdefRecord ndefRecord = ndefRecords[i];
            if (ndefRecord.isChunked()) {
                int payloadSize = ndefRecord.getPayloadSize();
                int k = i;
                do {
                    NdefRecord next;
                    if ((next = ndefRecords[++k]).getTnf() != 6) {
                        throw new IllegalArgumentException("Expected terminating 'unchanged' record type at " + i);
                    }
                    byte[] type = ndefRecord.getType();
                    if (type != null && type.length > 0) {
                        throw new IllegalArgumentException("Expected no record type at " + i);
                    }
                    payloadSize += next.getPayloadSize();
                    if (next.isChunked()) continue;
                    byte[] payload = new byte[payloadSize];
                    int offset = 0;
                    for (int p = i; p <= k; ++p) {
                        byte[] chunkPayload = ndefRecords[p].getPayload();
                        System.arraycopy(chunkPayload, 0, payload, offset, chunkPayload.length);
                        offset += chunkPayload.length;
                    }
                    NdefRecord unchunkedNdefRecord = new NdefRecord(ndefRecord.getTnf(), ndefRecord.getType(), ndefRecord.getId(), payload);
                    records.add(this.ndefRecordDecoder.decode(unchunkedNdefRecord, this));
                    i = k;
                    continue block0;
                } while (i < ndefRecords.length);
                throw new IllegalArgumentException("Expected terminating 'unchanged' record type");
            }
            records.add(this.ndefRecordDecoder.decode(ndefRecord, this));
        }
        return records;
    }

    public <T extends Record> T decodeToRecord(byte[] ndefMessage) {
        return this.decodeToRecord(ndefMessage, 0, ndefMessage.length);
    }

    public <T extends Record> T decodeToRecord(byte[] ndefMessage, int offset, int length) {
        NdefMessage message = this.decode(ndefMessage, offset, length);
        List<Record> records = this.decodeToRecords(message);
        if (records.size() == 1) {
            return (T)records.get(0);
        }
        throw new IllegalArgumentException("expected one record in payload but found: " + records.size());
    }

    public NdefMessage decode(byte[] ndefMessage) {
        return this.decode(ndefMessage, 0, ndefMessage.length);
    }

    public NdefMessage decode(byte[] ndefMessage, int offset, int length) {
        ByteArrayInputStream bais = new ByteArrayInputStream(ndefMessage, offset, length);
        return this.decode(bais);
    }

    public NdefMessage decode(InputStream bais) {
        ArrayList<NdefRecord> records = new ArrayList<NdefRecord>();
        try {
            while (bais.available() > 0) {
                int header = bais.read();
                byte tnf = (byte)(header & 7);
                int typeLength = bais.read();
                int payloadLength = this.getPayloadLength((header & 0x10) != 0, bais);
                int idLength = this.getIdLength((header & 8) != 0, bais);
                boolean chunked = (header & 0x20) != 0;
                byte[] type = RecordUtils.getBytesFromStream(typeLength, bais);
                byte[] id = RecordUtils.getBytesFromStream(idLength, bais);
                byte[] payload = RecordUtils.getBytesFromStream(payloadLength, bais);
                if (records.isEmpty() && (header & 0x80) == 0) {
                    throw new IllegalArgumentException("no Message Begin record at the begining");
                }
                if (bais.available() == 0 && (header & 0x40) == 0) {
                    throw new IllegalArgumentException("no Message End record at the end of array");
                }
                records.add(new NdefRecord(tnf, chunked, type, id, payload));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new NdefMessage(records.toArray(new NdefRecord[0]));
    }

    private int getIdLength(boolean idLengthPresent, InputStream bais) throws IOException {
        if (idLengthPresent) {
            return bais.read();
        }
        return 0;
    }

    private int getPayloadLength(boolean shortRecord, InputStream bais) throws IOException {
        if (shortRecord) {
            return bais.read();
        }
        byte[] buffer = RecordUtils.getBytesFromStream(4, bais);
        return (buffer[0] << 24) + (buffer[1] << 16) + (buffer[2] << 8) + (buffer[3] & 0xFF);
    }

    public List<Record> decodeToRecords(byte[] payload, int offset, int length) {
        return this.decodeToRecords(this.decode(payload, offset, length));
    }
}

