/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Iterator;
import org.nfctools.ndef.NdefRecord;
import org.nfctools.ndef.NdefRecordEncoder;
import org.nfctools.ndef.Record;

public class NdefMessageEncoder {
    private static final int MAX_LENGTH_FOR_SHORT_RECORD = 255;
    private NdefRecordEncoder ndefRecordEncoder;

    public NdefMessageEncoder(NdefRecordEncoder ndefRecordEncoder) {
        this.ndefRecordEncoder = ndefRecordEncoder;
    }

    public byte[] encodeSingle(Record record) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.encodeSingle(record, baos);
        return baos.toByteArray();
    }

    public void encodeSingle(Record record, ByteArrayOutputStream out) {
        byte header = -64;
        NdefRecord ndefRecord = this.ndefRecordEncoder.encode(record, this);
        this.writeNdefRecord(out, header, ndefRecord);
    }

    public byte[] encode(Record ... records) {
        return this.encode(Arrays.asList(records));
    }

    public byte[] encode(Iterable<? extends Record> records) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.encode(records, baos);
        return baos.toByteArray();
    }

    public void encode(Iterable<? extends Record> records, ByteArrayOutputStream baos) {
        byte header = -128;
        Iterator<? extends Record> it = records.iterator();
        while (it.hasNext()) {
            Record record = it.next();
            header = this.setMessageEndIfLastRecord(it, header);
            NdefRecord ndefRecord = this.ndefRecordEncoder.encode(record, this);
            this.writeNdefRecord(baos, header, ndefRecord);
            header = 0;
        }
    }

    private byte setMessageEndIfLastRecord(Iterator<? extends Record> it, byte header) {
        if (!it.hasNext()) {
            header = (byte)(header | 0x40);
        }
        return header;
    }

    private void writeNdefRecord(ByteArrayOutputStream baos, byte header, NdefRecord ndefRecord) {
        this.writeHeader(baos, header, ndefRecord);
        baos.write(ndefRecord.getType().length);
        this.writePayloadLength(baos, ndefRecord.getPayload().length);
        this.writeIdLength(baos, ndefRecord.getId().length);
        this.writeBytes(baos, ndefRecord.getType());
        this.writeBytes(baos, ndefRecord.getId());
        this.writeBytes(baos, ndefRecord.getPayload());
    }

    private void writeHeader(ByteArrayOutputStream baos, byte header, NdefRecord ndefRecord) {
        header = this.setShortRecord(header, ndefRecord);
        header = this.setIdLength(header, ndefRecord);
        header = this.setTypeNameFormat(header, ndefRecord);
        baos.write(header);
    }

    private byte setShortRecord(byte header, NdefRecord ndefRecord) {
        if (ndefRecord.getPayload().length <= 255) {
            header = (byte)(header | 0x10);
        }
        return header;
    }

    private byte setIdLength(byte header, NdefRecord ndefRecord) {
        if (ndefRecord.getId().length > 0) {
            header = (byte)(header | 8);
        }
        return header;
    }

    private byte setTypeNameFormat(byte header, NdefRecord ndefRecord) {
        header = (byte)(header | ndefRecord.getTnf());
        return header;
    }

    private void writeBytes(ByteArrayOutputStream baos, byte[] bytes) {
        baos.write(bytes, 0, bytes.length);
    }

    private void writeIdLength(ByteArrayOutputStream baos, int length) {
        if (length > 0) {
            baos.write(length);
        }
    }

    private void writePayloadLength(ByteArrayOutputStream baos, int length) {
        if (length <= 255) {
            baos.write(length);
        } else {
            byte[] payloadLengthArray = new byte[]{(byte)(length >>> 24), (byte)(length >>> 16), (byte)(length >>> 8), (byte)(length & 0xFF)};
            baos.write(payloadLengthArray, 0, payloadLengthArray.length);
        }
    }
}

