/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.ext;

import java.util.HashMap;
import java.util.Map;
import org.nfctools.ndef.NdefConstants;
import org.nfctools.ndef.NdefMessageDecoder;
import org.nfctools.ndef.NdefRecord;
import org.nfctools.ndef.ext.ExternalTypeRecord;
import org.nfctools.ndef.ext.ExternalTypeRecordConfig;
import org.nfctools.ndef.ext.UnsupportedExternalTypeRecord;
import org.nfctools.ndef.wkt.decoder.AbstractRecordDecoder;

public class ExternalTypeDecoder
extends AbstractRecordDecoder<ExternalTypeRecord> {
    private Map<String, ExternalTypeRecordConfig> recordDecoders = new HashMap<String, ExternalTypeRecordConfig>();

    public ExternalTypeDecoder() {
        super(4);
    }

    @Override
    protected ExternalTypeRecord createRecord(NdefRecord ndefRecord, NdefMessageDecoder messageDecoder) {
        String namespace = new String(ndefRecord.getType(), NdefConstants.DEFAULT_CHARSET);
        String content = new String(ndefRecord.getPayload(), NdefConstants.DEFAULT_CHARSET);
        ExternalTypeRecordConfig config = this.recordDecoders.get(namespace);
        if (config != null) {
            return config.getContentDecoder().decodeContent(content);
        }
        return new UnsupportedExternalTypeRecord(namespace, content);
    }

    public void addRecordConfig(ExternalTypeRecordConfig config) {
        this.recordDecoders.put(config.getNamespace(), config);
    }
}

