/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.ext;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nfctools.ndef.NdefDecoderException;
import org.nfctools.ndef.ext.ExternalTypeContentDecoder;
import org.nfctools.ndef.ext.ExternalTypeRecord;
import org.nfctools.ndef.ext.GeoRecord;

public class GeoRecordDecoder
implements ExternalTypeContentDecoder {
    private static final Pattern GEO_URL_PATTERN = Pattern.compile("([\\-0-9.]+),([\\-0-9.]+)(?:,([\\-0-9.]+))?(?:\\?(.*))?", 2);

    @Override
    public ExternalTypeRecord decodeContent(String content) {
        Double altitude;
        Double longitude;
        Double latitude;
        String addressInformation;
        Matcher matcher = GEO_URL_PATTERN.matcher(content);
        if (!matcher.matches()) {
            return null;
        }
        String query = matcher.group(4);
        if (query != null) {
            if (!query.startsWith("q=")) {
                throw new NdefDecoderException("Expected address information query starting with parameter 'q', found " + query);
            }
            addressInformation = query.substring(2);
        } else {
            addressInformation = null;
        }
        try {
            latitude = Double.parseDouble(matcher.group(1));
            if (latitude > 90.0 || latitude < -90.0) {
                throw new NdefDecoderException("Expected latitude within 90 positive or negative degrees, found " + latitude + " degrees.");
            }
        }
        catch (NumberFormatException nfe) {
            throw new NdefDecoderException("Expected float latitude, found '" + matcher.group(1) + "'");
        }
        try {
            longitude = Double.parseDouble(matcher.group(2));
            if (longitude > 180.0 || longitude < -180.0) {
                throw new NdefDecoderException("Expected longitude within 180 positive or negative degrees, found " + longitude + " degrees.");
            }
        }
        catch (NumberFormatException nfe) {
            throw new NdefDecoderException("Expected float longitude, found '" + matcher.group(2) + "'");
        }
        if ((longitude != 0.0 || latitude != 0.0) && addressInformation != null) {
            throw new NdefDecoderException("Expected latitude and longitude coordinates or address information, not both.");
        }
        if (matcher.group(3) == null) {
            altitude = null;
        } else {
            try {
                altitude = Double.parseDouble(matcher.group(3));
            }
            catch (NumberFormatException nfe) {
                throw new NdefDecoderException("Expected float altitude, found '" + matcher.group(3) + "'");
            }
        }
        GeoRecord geoRecord = new GeoRecord();
        if (addressInformation != null) {
            geoRecord.setAddressInformation(addressInformation);
        } else {
            geoRecord.setLatitude(latitude);
            geoRecord.setLongitude(longitude);
        }
        geoRecord.setAltitude(altitude);
        return geoRecord;
    }
}

