/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.mime;

import org.nfctools.ndef.NdefConstants;
import org.nfctools.ndef.NdefEncoderException;
import org.nfctools.ndef.NdefMessageEncoder;
import org.nfctools.ndef.NdefRecord;
import org.nfctools.ndef.Record;
import org.nfctools.ndef.mime.MimeRecord;
import org.nfctools.ndef.wkt.encoder.RecordEncoder;

public class MimeRecordEncoder
implements RecordEncoder {
    @Override
    public boolean canEncode(Record record) {
        return record instanceof MimeRecord;
    }

    @Override
    public NdefRecord encodeRecord(Record record, NdefMessageEncoder messageEncoder) {
        MimeRecord mimeRecord = (MimeRecord)record;
        if (!mimeRecord.hasContentType()) {
            throw new NdefEncoderException("Expected content type", mimeRecord);
        }
        return new NdefRecord(2, mimeRecord.getContentType().getBytes(NdefConstants.DEFAULT_CHARSET), record.getId(), mimeRecord.getContentAsBytes());
    }
}

