/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.decoder;

import java.util.List;
import org.nfctools.ndef.NdefMessage;
import org.nfctools.ndef.NdefMessageDecoder;
import org.nfctools.ndef.Record;
import org.nfctools.ndef.wkt.WellKnownRecordPayloadDecoder;
import org.nfctools.ndef.wkt.records.GcActionRecord;
import org.nfctools.ndef.wkt.records.GcDataRecord;
import org.nfctools.ndef.wkt.records.GcTargetRecord;
import org.nfctools.ndef.wkt.records.GenericControlRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class GenericControlRecordDecoder
implements WellKnownRecordPayloadDecoder {
    @Override
    public WellKnownRecord decodePayload(byte[] payload, NdefMessageDecoder messageDecoder) {
        byte configurationByte = payload[0];
        NdefMessage payloadNdefMessage = messageDecoder.decode(payload, 1, payload.length - 1);
        GcTargetRecord target = null;
        GcActionRecord action = null;
        GcDataRecord data = null;
        List<Record> subRecords = messageDecoder.decodeToRecords(payloadNdefMessage);
        for (Record record : subRecords) {
            if (record instanceof GcTargetRecord) {
                target = (GcTargetRecord)record;
                continue;
            }
            if (record instanceof GcActionRecord) {
                action = (GcActionRecord)record;
                continue;
            }
            if (record instanceof GcDataRecord) {
                data = (GcDataRecord)record;
                continue;
            }
            throw new RuntimeException("unexpected record " + record.getClass().getName());
        }
        if (target == null) {
            throw new IllegalArgumentException("no target record found in generic control record");
        }
        GenericControlRecord gcr = new GenericControlRecord(target, configurationByte);
        gcr.setAction(action);
        gcr.setData(data);
        return gcr;
    }
}

