/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.decoder;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;
import org.nfctools.ndef.NdefMessageDecoder;
import org.nfctools.ndef.RecordUtils;
import org.nfctools.ndef.wkt.WellKnownRecordPayloadDecoder;
import org.nfctools.ndef.wkt.records.TextRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class TextRecordDecoder
implements WellKnownRecordPayloadDecoder {
    @Override
    public WellKnownRecord decodePayload(byte[] payload, NdefMessageDecoder messageDecoder) {
        ByteArrayInputStream bais = new ByteArrayInputStream(payload);
        int status = bais.read();
        byte languageCodeLength = (byte)(status & 0x1F);
        String languageCode = new String(RecordUtils.getBytesFromStream(languageCodeLength, bais));
        byte[] textData = RecordUtils.getBytesFromStream(payload.length - languageCodeLength - 1, bais);
        Charset textEncoding = (status & 0x80) != 0 ? TextRecord.UTF16 : TextRecord.UTF8;
        try {
            String text = new String(textData, textEncoding.name());
            return new TextRecord(text, textEncoding, new Locale(languageCode));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

