/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.encoder;

import org.nfctools.ndef.NdefEncoderException;
import org.nfctools.ndef.NdefMessageEncoder;
import org.nfctools.ndef.wkt.WellKnownRecordPayloadEncoder;
import org.nfctools.ndef.wkt.records.GcActionRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class GcActionRecordEncoder
implements WellKnownRecordPayloadEncoder {
    @Override
    public byte[] encodePayload(WellKnownRecord wellKnownRecord, NdefMessageEncoder messageEncoder) {
        GcActionRecord actionRecord = (GcActionRecord)wellKnownRecord;
        byte[] payload = null;
        if (actionRecord.hasAction() && actionRecord.hasActionRecord()) {
            throw new NdefEncoderException("Expected action or action record, not both.", wellKnownRecord);
        }
        if (actionRecord.hasAction()) {
            payload = new byte[]{1, actionRecord.getAction().getValue()};
        } else if (actionRecord.hasActionRecord()) {
            byte[] subPayload = messageEncoder.encodeSingle(actionRecord.getActionRecord());
            payload = new byte[subPayload.length + 1];
            payload[0] = 0;
            System.arraycopy(subPayload, 0, payload, 1, subPayload.length);
        } else {
            throw new NdefEncoderException("Expected action or action record.", wellKnownRecord);
        }
        return payload;
    }
}

