/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.nfctools.ndef.NdefEncoderException;
import org.nfctools.ndef.NdefMessageEncoder;
import org.nfctools.ndef.wkt.WellKnownRecordPayloadEncoder;
import org.nfctools.ndef.wkt.records.GenericControlRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class GenericControlRecordEncoder
implements WellKnownRecordPayloadEncoder {
    @Override
    public byte[] encodePayload(WellKnownRecord wellKnownRecord, NdefMessageEncoder messageEncoder) {
        GenericControlRecord myRecord = (GenericControlRecord)wellKnownRecord;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(myRecord.getConfigurationByte());
            if (!myRecord.hasTarget()) {
                throw new NdefEncoderException("Expected target", myRecord);
            }
            baos.write(messageEncoder.encodeSingle(myRecord.getTarget()));
            if (myRecord.getAction() != null) {
                baos.write(messageEncoder.encodeSingle(myRecord.getAction()));
            }
            if (myRecord.getData() != null) {
                baos.write(messageEncoder.encodeSingle(myRecord.getData()));
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

