/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.handover.decoder;

import org.nfctools.ndef.NdefConstants;
import org.nfctools.ndef.NdefMessageDecoder;
import org.nfctools.ndef.ext.UnsupportedExternalTypeRecord;
import org.nfctools.ndef.wkt.WellKnownRecordPayloadDecoder;
import org.nfctools.ndef.wkt.handover.records.HandoverCarrierRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class HandoverCarrierRecordDecoder
implements WellKnownRecordPayloadDecoder {
    @Override
    public WellKnownRecord decodePayload(byte[] payload, NdefMessageDecoder messageDecoder) {
        byte[] carrierData;
        HandoverCarrierRecord handoverCarrierRecord = new HandoverCarrierRecord();
        HandoverCarrierRecord.CarrierTypeFormat carrierTypeFormat = HandoverCarrierRecord.CarrierTypeFormat.toCarrierTypeFormat((byte)(payload[0] & 7));
        handoverCarrierRecord.setCarrierTypeFormat(carrierTypeFormat);
        int carrierTypeLength = payload[1] & 0xFF;
        byte[] carrierType = new byte[carrierTypeLength];
        System.arraycopy(payload, 2, carrierType, 0, carrierTypeLength);
        switch (carrierTypeFormat) {
            case WellKnown: {
                Object record = messageDecoder.decodeToRecord(carrierType);
                if (record instanceof WellKnownRecord) {
                    handoverCarrierRecord.setCarrierType(record);
                    break;
                }
                throw new IllegalArgumentException("Expected well-known type carrier type");
            }
            case Media: {
                handoverCarrierRecord.setCarrierType(new String(carrierType, NdefConstants.DEFAULT_CHARSET));
                break;
            }
            case AbsoluteURI: {
                handoverCarrierRecord.setCarrierType(new String(carrierType, NdefConstants.DEFAULT_CHARSET));
                break;
            }
            case External: {
                Object record = messageDecoder.decodeToRecord(carrierType);
                if (record instanceof UnsupportedExternalTypeRecord) {
                    handoverCarrierRecord.setCarrierType(record);
                } else {
                    throw new IllegalArgumentException("Expected external type carrier type");
                }
            }
            default: {
                throw new RuntimeException();
            }
        }
        int carrierDataLength = payload.length - 2 - carrierTypeLength;
        if (carrierDataLength > 0) {
            carrierData = new byte[carrierDataLength];
            System.arraycopy(payload, 2 + carrierTypeLength, carrierData, 0, carrierDataLength);
        } else {
            carrierData = NdefConstants.EMPTY_BYTE_ARRAY;
        }
        handoverCarrierRecord.setCarrierData(carrierData);
        return handoverCarrierRecord;
    }
}

